import type { FormFieldType } from "@/shared/types/common"
import {
  faNoteSticky,
  faEuro,
  faHashtag,
} from "@fortawesome/free-solid-svg-icons"
import { IIncident } from "@/shared/types/flottes/incident"
import { _SINISTRE_OPTION_STATUT, _TYPES_SINISTRES, ENVOI_DECLARATION_OPTIONS } from "@/shared/_mock/flottes/_Incidents"
import { _BINARY_Qst } from "@/shared/_mock/_trajets"
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver"
import { IMMATRICULATIONS } from "@/shared/_mock"

export const TYPE_OPTIONS = Object.values(_TYPES_SINISTRES).map((type) => ({
  label: type,
  value: type,
}));

export const SINISTRE_CORPOREL_OPTIONS = [
  { label: "Non", value: "Non" },
  { label: "Oui", value: "Oui" }
];

export const mainIncidentFormFields: FormFieldType<IIncident>[] = [
  {
    name: "driver",
    label: "Chauffeur",
    type: "select",
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })),
    placeholder: "Choisissez un chauffeur",
  },
  {
    name: "vehicule",
    label: "Véhicule",
    type: "select",
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Choisissez une véhicule",
  },
  {
    name: "dateSinistre",
    label: "Date",
    type: "date",
  },
  {
    name: "typeSinistre",
    label: "Type de sinistre",
    type: "select",
    options: TYPE_OPTIONS,
    placeholder: "Choisissez un type",
  },
  {
    name: "statut",
    label: "Statut",
    type: "select",
    options: _SINISTRE_OPTION_STATUT,
    placeholder: "Choisissez un état",
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
];

export const descriptionIncidentFormFields: FormFieldType<IIncident>[] = [
  {
    name: "constat",
    label: "Constat",
    type: "select",
    options: _BINARY_Qst,
    placeholder: "Choisissez une option",
  },
  {
    name: "envoiDeclaration",
    label: "Envoi de la déclaration",
    type: "select",
    options: ENVOI_DECLARATION_OPTIONS,
    placeholder: "Choisissez une option",
  },
  {
    name: "dateDeclaration",
    label: "Date de déclaration",
    type: "date",
  },
  {
    name: "dateCloture",
    label: "Date de clôture",
    type: "date",
  },
  {
    name: "montantFranchise",
    label: "Montant Franchise",
    type: "number",
    placeholder: "Entrez le montant",
    icon: faEuro,
  },
  {
    name: "numeroDossier",
    label: "N° de dossier",
    type: "text",
    placeholder: "Entrez le numéro de dossier",
    icon: faHashtag,
  },
];
