import { type TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { _supplierTypes, DEFAULT_SUPPLIER_TYPE_TABLE_HEAD } from '@/shared/_mock/flottes/_supplier';
import { ISupplierType } from '@/shared/types/flottes/vehicule';

const supplierTypeConfig: TableConfig<ISupplierType> = {
  initialData: _supplierTypes,
  defaultTableHead: DEFAULT_SUPPLIER_TYPE_TABLE_HEAD,
};

export function useSupplierTypeTable() {
  return useTableManager<ISupplierType>(supplierTypeConfig);
} 