import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_VEHICLE_TYPE_DATA } from "@/shared/_mock/flottes/_vehicle"
import { IVehicleType } from "@/shared/types/flottes/vehicule"

const vehicleTypeConfig: TabConfig<IVehicleType> = {
  type: "type de véhicule",
  listTitle: "Liste des types de véhicules",
  newItemTitle: "Nouveau type de véhicule",
  initialData: INITIAL_VEHICLE_TYPE_DATA,
  getItemCode: (vehicleType) => vehicleType.intitule,
}

export function useVehicleTypeTabs() {
  return useTabsManager<IVehicleType>(vehicleTypeConfig)
}
