import { CandidatureStatut, ICandidature, IFormulaire } from '@/shared/types/candidature';
import { FormFieldType } from '@/shared/types/common';
import { faFileLines, faLink, faFont } from '@fortawesome/free-solid-svg-icons';

export const formFieldsFormulaire: FormFieldType<IFormulaire>[] = [
  {
    name: 'nom',
    label: 'Nom du formulaire',
    type: 'text',
    placeholder: 'Entrez le nom du formulaire',
    required: true,
    icon: faFont,
  },
  {
    name: 'lien',
    label: 'Lien du formulaire',
    type: 'text',
    placeholder: 'Entrez le lien du formulaire',
    required: true,
    icon: faLink,
  },
  {
    name: 'description',
    label: 'Description',
    type: 'textarea',
    placeholder: 'Entrez une description du formulaire',
    icon: faFileLines,
  },
]; 

export const getCandidatureFields = (isSedentaire: boolean): FormFieldType<ICandidature>[] => [
  {
      name: 'nom',
      label: 'Nom',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'prenom',
      label: 'Prénom',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'sourceCandidat',
      label: 'Source candidat',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'email',
      label: 'Email',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'email_pro',
      label: 'Email Pro',
      type: 'text',
      required: false,
      showWhen: (status) => status === CandidatureStatut.Valide,
    },
    {
      name: 'telephone',
      label: 'Téléphone',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'codePostal',
      label: 'Code postal',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'ville',
      label: 'Ville',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'age',
      label: 'Age',
      type: 'number',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'departement',
      label: 'Département',
      type: 'text',
      required: true,
      showWhen: () => true, // Always show
    },
    {
      name: 'document',
      label: 'Document',
      type: 'custom',
      showWhen: () => true, // Always show
    },
    {
      name: 'address',
      label: 'Adresse',
      type: 'address',
      required: true,
      showWhen: () => true,
    },
    {
      name: 'contrat_document',
      label: 'Contrat',
      type: 'custom',
      showWhen: (status) => status === CandidatureStatut.Valide,
    },
    // Fields specific to ATraiter status
    {
      name: 'suiviAppel',
      label: 'Suivi d\'appel',
      type: 'text',
      required: true,
      showWhen: (status) => status === CandidatureStatut.ATraiter,
    },
    {
      name: 'dateAppelRappel',
      label: 'Date appel ou rappel',
      type: 'date',
      required: true,
      showWhen: (status) => status === CandidatureStatut.ATraiter,
    },
    {
      name: 'dateCandidature',
      label: 'Date de candidature',
      type: 'date',
      required: true,
      showWhen: (status) => status === CandidatureStatut.ATraiter,
    },
    // Fields for chauffeur type
    {
      name: 'dureePermis',
      label: 'Durée de permis',
      type: 'text',
      required: true,
      showWhen: (status) => !isSedentaire,
    },
    {
      name: 'proximiteCircuit',
      label: 'À proximité du circuit',
      type: 'text',
      required: true,
      showWhen: (status) => !isSedentaire,
    },
    // Fields for status management
    {
      name: 'statut',
      label: 'Statut',
      type: 'select',
      required: true,
      options: [
        { value: CandidatureStatut.ATraiter, label: 'À traiter' },
        { value: CandidatureStatut.EnCours, label: 'En cours' },
        { value: CandidatureStatut.Retenu, label: 'Retenu' },
        { value: CandidatureStatut.Valide, label: 'Validé' },
        { value: CandidatureStatut.Refuse, label: 'Refusé' },
        { value: CandidatureStatut.Blackliste, label: 'Blacklisté' },
        { value: CandidatureStatut.Absent, label: 'Absent' },
      ],
      showWhen: () => true, // Always show
    },
    // Fields for Retenu/Valide status
    {
      name: 'dateHeureRdvAgence',
      label: 'Replanifier un RDV',
      type: 'date',
      required: true,
      showWhen: (status) => [CandidatureStatut.Retenu, CandidatureStatut.Valide, CandidatureStatut.Absent].includes(status),
    },
    // Fields for Refuse/Blackliste status
    {
      name: 'raisonRefus',
      label: 'Raison du refus',
      type: 'textarea',
      required: true,
      showWhen: (status) => [CandidatureStatut.Refuse, CandidatureStatut.Blackliste].includes(status),
    },
    // Fields for Valide status
    {
      name: 'contrat',
      label: 'Statut du contrat',
      type: 'select',
      required: true,
      options: [
        { value: 'signé', label: 'Signé' },
        { value: 'non signé', label: 'Non signé' },
      ],
      showWhen: (status) => status === CandidatureStatut.Valide || status === CandidatureStatut.Retenu,
    },
    // Fields for other statuses like disponibilite
    {
      name: 'disponibilite',
      label: 'Disponibilité',
      type: 'text',
      required: true,
      showWhen: (status) => [CandidatureStatut.ATraiter, CandidatureStatut.Retenu].includes(status),
    },

  ];

  