import {
  Dialog, DialogActions, DialogContent, DialogContentText, DialogTitle, Button
} from "@mui/material";

interface ConfirmDeleteDialogProps {
  open: boolean;
  onClose: () => void;
  onConfirm: () => void;
  itemName: string;
}

export default function ConfirmDeleteDialog({
  open, onClose, onConfirm, itemName
}: ConfirmDeleteDialogProps) {
  return (
    <Dialog open={open} onClose={onClose}>
      <DialogTitle>Supprimer</DialogTitle>
      <DialogContent>
        <DialogContentText>
          Êtes-vous sûr de vouloir supprimer le dossier <strong>{itemName}</strong> ?
          Cette action est irréversible.
        </DialogContentText>
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose}>Annuler</Button>
        <Button onClick={onConfirm} color="error" variant="contained">Supprimer</Button>
      </DialogActions>
    </Dialog>
  );
}
