import { useState, useEffect } from "react";
import {
  Dialog, DialogTitle, DialogContent, DialogActions,
  Button, TextField
} from "@mui/material";

interface RenameFolderDialogProps {
  open: boolean;
  onClose: () => void;
  onRename: (newName: string) => void;
  initialName: string;
}

export default function RenameFolderDialog({
  open, onClose, onRename, initialName
}: RenameFolderDialogProps) {
  const [name, setName] = useState(initialName);

  useEffect(() => {
    setName(initialName);
  }, [initialName]);

  return (
    <Dialog open={open} onClose={onClose}>
      <DialogTitle>Renommer le dossier</DialogTitle>
      <DialogContent>
        <TextField
         sx={{marginTop : 1}}
          fullWidth
          value={name}
          onChange={(e) => setName(e.target.value)}
          label="Nouveau nom"
        />
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose}>Annuler</Button>
        <Button
          onClick={() => onRename(name)}
          variant="contained"
          disabled={!name.trim()}
        >
          Renommer
        </Button>
      </DialogActions>
    </Dialog>
  );
}
