'use client';

import React, { useState } from 'react';
import { Box, Typography, Paper, SelectChangeEvent } from '@mui/material';
import NotificationHeader from '../components/notifications-header';
import DesktopNotificationBanner from '../components/desktop-notification-banner';
import NotificationChannels from '../components/notifications-channels';
import NotificationSettingsSection from '../components/notifications-setting-section';
import { HEADER } from '@/layouts/config-layout';


const NotificationsView = () => {
  const [notificationChannel, setNotificationChannel] = useState('monday');
  const [emailChannel, setEmailChannel] = useState('none');
  
  const [notificationSettings, setNotificationSettings] = useState({
    mentions: { app: false, email: false },
    updates_owned: { app: false, email: false },
    updates_subscribed: { app: false, email: false },
    replies: { app: false, email: false }
  });

  const handleNotificationChannelChange = (event: SelectChangeEvent) => {
    setNotificationChannel(event.target.value);
    setNotificationSettings(prev => ({
      mentions: { ...prev.mentions, app: false },
      updates_owned: { ...prev.updates_owned, app: false },
      updates_subscribed: { ...prev.updates_subscribed, app: false },
      replies: { ...prev.replies, app: false }
    }));
  };

  const handleEmailChannelChange = (event: SelectChangeEvent) => {
    setEmailChannel(event.target.value);
    setNotificationSettings(prev => ({
      mentions: { ...prev.mentions, email: false },
      updates_owned: { ...prev.updates_owned, email: false },
      updates_subscribed: { ...prev.updates_subscribed, email: false },
      replies: { ...prev.replies, email: false }
    }));
  };

  const handleSettingChange = (key: keyof typeof notificationSettings, channel: 'app' | 'email', value: boolean) => {
    setNotificationSettings(prev => ({
      ...prev,
      [key]: {
        ...prev[key],
        [channel]: value
      }
    }));
  };

  const handleActivateDesktopNotifications = () => {

  };

  const handleIgnoreDesktopNotifications = () => {

  };

  return (
    <Box
    sx={{
      display: 'flex',
      flexDirection: 'column',
      height: `calc(100vh - ${HEADER.H_DESKTOP +  16}px)`,
      overflow: 'auto',
      '&::-webkit-scrollbar': {
        width: '8px',
      },
      '&::-webkit-scrollbar-thumb': {
        backgroundColor: 'rgba(0,0,0,0.1)',
        borderRadius: '4px',
      },
      '&::-webkit-scrollbar-track': {
        backgroundColor: 'transparent',
      },
      pb: 2,
      px: 1,
    }}
  >
    <Box sx={{ p: 3 }}>
      <NotificationHeader />

      <DesktopNotificationBanner 
        onActivate={handleActivateDesktopNotifications}
        onIgnore={handleIgnoreDesktopNotifications}
      />

      <Typography variant="body1" sx={{ mb: 3 }}>
        Sélectionnez les notifications que vous souhaitez recevoir
      </Typography>

      <Paper sx={{ p: 3, borderRadius: 3 }}>
        <NotificationChannels 
          notificationChannel={notificationChannel}
          emailChannel={emailChannel}
          onNotificationChannelChange={handleNotificationChannelChange}
          onEmailChannelChange={handleEmailChannelChange}
        />

        <NotificationSettingsSection 
          notificationSettings={notificationSettings}
          onSettingChange={handleSettingChange }
        />
      </Paper>
    </Box>
    </Box>
  );
};

export default NotificationsView;