'use client';
import { useCallback, useState } from 'react';
import { IContrat } from '@/shared/types/contract';
import { INITIAL_CONTRACT_DATA } from '@/shared/_mock/_Contrat';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { ITrajet } from '@/shared/types/trajet';
import { INITIAL_TRAJET_DATA } from '@/shared/_mock/_trajets';
import { useTrajetStore } from '@/shared/api/stores/trajetStore';
import { TypeTrajet, BinaryQuestion } from '@/shared/types/trajet';

const trajetConfig: TabConfig<ITrajet> = {
  type: 'trajet',
  listTitle: 'Liste des trajets',
  newItemTitle: 'Nouveau trajet',
  initialData: INITIAL_TRAJET_DATA,
  getItemCode: (trajet) => trajet.intitule,
};

export function useTrajetTabs() {
  const { getTrajetById } = useTrajetStore();

  const tabsManager = useTabsManager<ITrajet>(trajetConfig);
  const [error, setError] = useState<string | null>(null);

  const handleView = useCallback(
    async (trajet: ITrajet) => {
      if (trajet.id) {
        try {
          const fullTrajet = await getTrajetById(trajet.id);

          if (fullTrajet) {
            const completeTrajet: ITrajet = {
              ...fullTrajet,

              intitule: fullTrajet.intitule || trajet.intitule || fullTrajet.id,
              circuitAvenant: fullTrajet.circuitAvenant || trajet.circuitAvenant || '',
              dateDebut: fullTrajet.dateDebut || trajet.dateDebut || '',
              etat: fullTrajet.etat || trajet.etat || '',
              typeTrajet: fullTrajet.tripType === 'NORMAL' ? TypeTrajet.Normal : TypeTrajet.personnalise,
              chauffeur: fullTrajet.chauffeur || trajet.chauffeur || '',
              vehicule: fullTrajet.vehicule || trajet.vehicule || '',
              sensAR: fullTrajet.sensAR || trajet.sensAR || '',
              rotation: fullTrajet.rotation ? BinaryQuestion.Oui : BinaryQuestion.Non,
              hasTolls: fullTrajet.hasTolls || false,
            };
            tabsManager.handleView(completeTrajet);
            return;
          }
        } catch (error) {
          setError(error as string);
        }
      }

      tabsManager.handleView(trajet);
    },
    [getTrajetById, tabsManager]
  );

  return {
    ...tabsManager,
    handleView,
  };
}
