import { _BINARY_Qst, _OPTION_VEHICULE, _TRAJET_ETAT, _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import { FormFieldType } from '@/shared/types/common';
import { IAddPoint, ITrajet } from '@/shared/types/trajet';
import { _SENS_AR, ETS_NAMES } from '@/shared/_mock';

import {
  faHashtag,
  faTag,
  faAddressCard,
  faStickyNote,
  faLocationDot,
  faMapMarked,
  faCar,
} from '@fortawesome/free-solid-svg-icons';

export const trajetformFields: FormFieldType<ITrajet>[] = [
  {
    name: 'intitule',
    label: 'Intitulé du trajet',
    type: 'text',
    icon: faTag,
    required: true,
  },
  {
    name: 'circuitAvenant',
    label: 'Circuit, Avenant',
    type: 'text',
    placeholder: 'Entrez une valeur',
    required: true,
    icon: '/assets/icons/menu/ic_exploitation.svg',
  },
  {
    name: 'dateDebut',
    label: 'Date de l\'avenant',
    type: 'date',
  },
  {
    name: 'etat',
    label: 'Etat',
    type: 'select',
    options: _TRAJET_ETAT,
  },
  {
    name: 'typeTrajet',
    label: 'Type',
    type: 'select',
    options: _TRAJET_TYPE,
  },
  {
    name: 'datePersonnalisation',
    label: 'Trajet personnalisé au',
    type: 'date',
  },

  {
    name: 'chauffeur',
    label: 'Chauffeur',
    placeholder: 'Entrez un nom',
    type: 'text',
    icon: faAddressCard,
  },
  {
    name: 'vehicule',
    label: 'Véhicule',
    options:_OPTION_VEHICULE,
    type: 'text',
    icon: faCar,
  },

  {
    name: 'peages',
    label: 'Péages inclus',
    type: 'checkbox',
    options: _BINARY_Qst,
  },
  {
    name: 'sensAR',
    label: 'Trajet',
    type: 'checkbox',
    options: _SENS_AR,
  },
  {
    name: 'rotation',
    label: 'Rotation',
    type: 'checkbox',
    options: _BINARY_Qst,
  },
  {
    name: 'observationPersonnalisation',
    label: 'Observation / Objet de le personnalisation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
  {
    name: 'jours',
    label: "Jours",
    placeholder: 'Entrez un nom',
    type: 'select',
    options: [
      { value: 'lundi', label: 'Lundi' },
      { value: 'mardi', label: 'Mardi' },
    ]
  },
  {
    name: 'observationFeuilleRoute',
    label: 'Observation feuille de route',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },

];


export const ETS_OPTIONS = Object.values(ETS_NAMES).map((ets) => ({
  label: ets,
  value: ets,
}));

export const addPointFormFields: FormFieldType<IAddPoint>[] = [

  {
    name: "endPoint",
    label: "Intitulé End Point",
    type: "text",
    icon: faTag,
    placeholder: 'Entrez un texte',
  },
  {
    name: "endPointAddress",
    label: "Adresse End Point",
    type: "address",
    placeholder: 'Adresse, code postal, ville',
  },
  
  {
    name: "user",
    label: "Usager",
    type: "select",
    options: [],
    required: true,
  },
  
]
