import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { ITrajet, TypeTrajet } from '@/shared/types/trajet';
import { ContratStyledRow, getStatusColor, StatusChip } from '../../contract/styles';
import {
  _BINARY_Qst,
  _TRAJET_ETAT,
  _TRAJET_TYPE,
} from '@/shared/_mock/_trajets';
import TableActionColumn from '@/shared/components/table/table-action-column';
import StatusMenu from '@/shared/components/table/StatusMenu';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEditContract: (trajet: ITrajet) => void;
  handleDetailsContract: (trajet: ITrajet) => void;
  selected: boolean;
  row: ITrajet;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  onStatusChange: (row: ITrajet, newStatus: string, field: keyof ITrajet) => void;
};
const TOOLTIP_TITLES = {
  duplicate: 'Copier trajet',
  active: 'Trajet Actif',
  inactive: 'Trajet Inactif',
};
export default function HistoriqueTrajetTableRow({
  dense,
  row,
  handleEditContract,
  handleDetailsContract,
  selected,
  onSelectRow,
  columns,
  onStatusChange,
}: Props) {

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "dateDebut":
        return formatDate(value, dateFormat.isoDate)
      case "etat":
        return (
          <StatusMenu
            value={value}
            options={_TRAJET_ETAT}
            onChange={(newStatus) => onStatusChange(row, newStatus, "etat")}
            chipComponent={StatusChip}
            sx={{ width: "140px" }}
          />
        )
      case "rotation":
        return (
          <StatusMenu
            value={value}
            options={_BINARY_Qst}
            onChange={(newStatus) => onStatusChange(row, newStatus, "rotation")}
            chipComponent={StatusChip}
            sx={{ width: "90px" }}
          />
        )
      case "peages":
        return (
          <StatusMenu
            value={value}
            options={_BINARY_Qst}
            onChange={(newStatus) => onStatusChange(row, newStatus, "peages")}
            chipComponent={StatusChip}
            sx={{ width: "90px" }}
          />
        )
      case "typeTrajet":
        return (
          <StatusMenu
            value={value}
            options={_TRAJET_TYPE}
            onChange={(newStatus) => onStatusChange(row, newStatus, "typeTrajet")}
            chipComponent={StatusChip}
            sx={{ width: "170px" }}
          />
        )
      default:
        return value
    }
  }


  return (
    <ContratStyledRow
      sx={{
        backgroundColor: row.typeTrajet === TypeTrajet.personnalise ? '#FEF8E7' : '',
      }}
      hover
      style={{ cursor: 'pointer' }}
    >
      {columns
        .filter((column) => column.id !== 'isActive')
        .map((column: any, index: number) => (
          <TableCell
            onDoubleClick={() => handleDetailsContract(row)}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: 'nowrap', py: column.id === 'etat' ? 0.2 : dense ? 0 : 1, ...(index === 0 && {
              position: 'relative',
            }), }}
          >
            <ConditionalComponent isValid={index === 0}>
              <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.etat),
                }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof ITrajet])}
          </TableCell>
        ))}
      <TableCell align="right" sx={{ px: 1, whiteSpace: 'nowrap' }}>
        <TableActionColumn
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  );
}
