import { _CIRCUIT_STATUS } from '@/shared/_mock/_circuit';
import { _BINARY_Qst, _TRAJET_ETAT, _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import { _SENS_AR } from '@/shared/_mock';
import { _classes } from '@/shared/_mock/_usagers';
import { FormFieldType } from '@/shared/types/common';
import { Civility, IPassengerList,  SchoolClass, CustodyCategory, ParticularityTransport, _PassengerStatus, RelationType } from '@/shared/types/passenger';
import { DatePickerFormat } from '@/utils/format-time';
import {
  faUserTie,
  faMagnifyingGlassLocation,
  faListUl,
  faStickyNote,
} from '@fortawesome/free-solid-svg-icons';
import dayjs from 'dayjs';
import { toTitleCase } from '@/utils/helper';

export const _classesOptions = Object.values(SchoolClass).map(className => ({
  value: className,
  label: className.length > 3 ? toTitleCase(className) : className
}));

const _custodyCategoryOptions = Object.values(CustodyCategory).map(category => ({
  value: category,
  label: toTitleCase(category.replace(/_/g, ' '))
}));

const _particularityTransportOptions = Object.values(ParticularityTransport).map(particularity => ({
  value: particularity,
  label: toTitleCase(particularity.replace(/_/g, ' '))
}));

export function calculateAge(birthDate: DatePickerFormat): number | null {
  if (!birthDate) return null;
  const today = dayjs();
  const birthDayjs = dayjs(birthDate);
  if (!birthDayjs.isValid()) return null;
  
  let age = today.year() - birthDayjs.year();
  const monthDiff = today.month() - birthDayjs.month();
  
  if (monthDiff < 0 || (monthDiff === 0 && today.date() < birthDayjs.date())) {
    age--;
  }
  
  return age;
}

export const _CIVILITE = [
  { value: Civility.MR, label: "M." },
  { value: Civility.MME, label: "Mme" },
  { value: Civility.M_MME, label: "M. et Mme" },
  { value: Civility.MM, label: "MM" },
  { value: Civility.MMS, label: "MMS" },
  { value: Civility.OTHER, label: "Autre" },
];

export const mainPassengerFormFields: FormFieldType<IPassengerList>[] = [
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE,
  },
  {
    name: 'lastName',
    label: 'Nom',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'firstName',
    label: 'Prénom',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
];

export const getPassengerFormFields = (
  etablissementOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[],
) : FormFieldType<IPassengerList>[] => [
    {
      name: 'state',
      label: 'État',
      type: 'select',
      required: true,
      options: _PassengerStatus,
    },
    {
      name: 'birthDate',
      label: 'Date de naissance',
      type: 'date',
      placeholder: 'JJ/MM/AAAA',
    },
    {
      name: 'birthPlace',
      label: 'Lieu de naissance',
      placeholder: 'Entrer un lieu de naissance',
      type: 'text',
      icon: faMagnifyingGlassLocation,
    },
    {
      name: 'startTransport',
      label: 'Début du transport',
      type: 'date',
      required: true,
    },
    {
      name: 'idDepartment',
      label: 'Département',
      type: 'select',
      options: departmentOptions,
      required: true,
    },
    {
      name: 'idEstablishment',
      label: 'Établissement',
      type: 'select',
      options: etablissementOptions,
      required: true,
    },
    {
      name: 'openingDays',
      label: 'Jours d\'ouverture',
      type: 'date',
    },
    {
      name: 'specificity',
      label: 'Spécificité',
      type: 'text',
      placeholder: 'Entrez une spécificité',
      icon: faListUl,
    },
    {
      name: 'schoolClass',
      label: 'Classe',
      type: 'select',
      options: _classesOptions,
    },
    {
      name: 'particularityTransport',
      label: 'Particularité de transport',
      type: 'select',
      options: _particularityTransportOptions,
    },
  ];


export const passengerFormFieldsSecondary: FormFieldType<IPassengerList>[] = [
  {
    name: 'custodyCategory',
    label: 'catégorie',
    type: 'select',
    options: _custodyCategoryOptions,
  },
  {
    name: 'referentTeacherName',
    label: 'Enseig. référent',
    type: 'text',
    placeholder: 'Entrez un texte',
    icon: faUserTie,
  },
  {
    name: 'observations',
    label: 'Observations',
    type: 'textarea',
    placeholder: 'Ajoutez une note ou une observation',
    icon: faStickyNote,
  },
];

export const _RELATION_TYPE_OPTIONS = [
  { value: RelationType.MOTHER, label: "Mère" },
  { value: RelationType.FATHER, label: "Père" },
  { value: RelationType.GRANDPARENT, label: "Grand-parent" },
  { value: RelationType.GROUP_HOME, label: "Foyer" },
  { value: RelationType.MEDICAL_FACILITY, label: "Établissement médical" },
  { value: RelationType.OTHER, label: "Autre" }
];