import * as yup from 'yup';
import { calculateAge } from './form-fields-usager';
import { Civility, RelationType } from '@/shared/types/usager';
import * as Yup from 'yup';

export const usagerSchema = yup.object().shape({
  civilite: yup.string().required('La civilité est requise'),
  nom: yup.string().required('Le nom est requis'),
  prenom: yup.string().required('Le prénom est requis'),
  etat: yup.string().required('L\'état est requis'),
  dateNaissance: yup.date()
    .nullable()
    .test('age-validation', 'L\'âge doit être valide', function(value) {
      if (!value) return true;
      const age = calculateAge(value);
      return age !== null && age >= 0 && age <= 120; 
    }),
  lieuNaissance: yup.string(),
  entreeLe: yup.date().required('La date de début du transport est requise'),
  department: yup.string(),
  etablissement: yup.string().required('L\'établissement est requis'),
  joursOuverture: yup.date().nullable(),
  specificite: yup.string(),
  classe: yup.string(),
  ParticulariteTransport: yup.string(),
  categorie: yup.string(),
  enseig: yup.string(),
  observation: yup.string(),
});

export const representativeSchema = yup.object().shape({
  id: yup.string(),
  civilite: yup.string()
    .oneOf(Object.values(Civility), 'Civilité invalide')
    .required('La civilité est requise'),
  firstName: yup.string().required('Le prénom est requis'),
  lastName: yup.string().required('Le nom est requis'),
  type: yup.string()
    .oneOf(Object.values(RelationType), 'Type de relation invalide')
    .required('Le type de relation est requis'),
  parentFirstName: yup.string().required('Le prénom du parent est requis'),
  parentLastName: yup.string().required('Le nom du parent est requis'),
  address: yup.object().shape({
    address: yup.string().required('L\'adresse est requise'),
    lat: yup.number(),
    lng: yup.number(),
  }),
  schedule: yup.object().shape({
    pair: yup.object().shape({
      all: yup.boolean(),
      ret: yup.boolean()
    }),
    impair: yup.object().shape({
      all: yup.boolean(),
      ret: yup.boolean()
    })
  }),
  mobile: yup.array().of(
    yup.string()
      .matches(/^[0-9]+$/, 'Le numéro doit contenir uniquement des chiffres')
      .min(10, 'Le numéro doit contenir au moins 10 chiffres')
      .max(15, 'Le numéro ne doit pas dépasser 15 chiffres')
  ),
  fixe: yup.array().of(
    yup.string()
      .matches(/^[0-9]+$/, 'Le numéro doit contenir uniquement des chiffres')
      .min(10, 'Le numéro doit contenir au moins 10 chiffres')
      .max(15, 'Le numéro ne doit pas dépasser 15 chiffres')
  ),
  personne: yup.array().of(
    yup.string()
      .matches(/^[0-9]+$/, 'Le numéro doit contenir uniquement des chiffres')
      .min(10, 'Le numéro doit contenir au moins 10 chiffres')
      .max(15, 'Le numéro ne doit pas dépasser 15 chiffres')
  ),
  email: yup.string()
    .email('Format email invalide')
    .required('Email est requis'),
  circuit: yup.string(),
  autoParentale: yup.string(),
  notificationArivee: yup.string(),
  observation: yup.string()
});

export const otherInterlocutorsSchema = yup.object().shape({
  civilite: yup.string(),
  firstName: yup.string().required('Le nom est requis'),
  lastName: yup.string().required('Le prénom est requis'),
  mobile: yup.string(),
  email: yup.string().email('Email invalide'),
  type: yup.string(),
  observation: yup.string()
});

export const avenantUsagerSchema = Yup.object().shape({
  dateApplication: Yup.string().required('La date d\'application est requise'),
  codeCircuit: Yup.string().required('Le code circuit est requis'),
  intituleCircuit: Yup.string().required('L\'intitulé du circuit est requis'),
  objetAvenant: Yup.string().required('L\'objet de l\'avenant est requis'),
  specificite: Yup.string().required('La specificite est requis'),
  avenantTemporaire: Yup.string(),
  observation: Yup.string()
});