import { _SENS_AR } from '../_mock';
import { Sens } from './circuit';
import { TableColumn } from './common';
export enum EtatDemandeRecue {
  EnCours = 'en_cours',
  NonTraite = 'non_traite',
  Traite = 'traite'
}

export enum EtatDemandeTraitee {
  Traite = 'traite',
  Annule = 'annule',
  Averti = 'averti'
}
export interface IPassenger {
  id: number
  firstName: string
  lastName: string
  establishmentName: string
  departmentName: string
}
export interface IAbsence {
  id: string
  usager: IPassenger
  etat: string | string[]
  etablissement: string
  dateDebut: string
  dateFin: string
  sensAR: string[]
  observation: string
  modeReception: string
  previentLe: string
  departement: string
  comment: string
  par: string
}

export type AbsenceTableRowProps<T> = {
  handleEdit: (item: T) => void;
  handleDetails: (item: T) => void;
  selected: boolean;
  row: T;
  dense: boolean;
  isTraiteTable?: boolean;
  onSelectRow: VoidFunction;
  onStatusChange?: (row: T, newStatus: string, field: keyof T) => void;
  onConcernedTripChange?: (row: T, newValue: string[]) => void;
  columns: TableColumn[];
};

export enum ConcernedTrip {
  Outbound = 'Outbound',
  Return = 'Return'
}

export enum ReceivingMethod {
  SMS = 'SMS',
  EMAIL = 'EMAIL',
  APPLICATION = 'APPLICATION'
}

// Function to map frontend Sens to backend ConcernedTrip
export const mapSensToConcernedTrip = (sens: Sens): ConcernedTrip => {
  switch (sens) {
    case Sens.Aller:
      return ConcernedTrip.Outbound;
    case Sens.Retour:
      return ConcernedTrip.Return;
    default:
      return ConcernedTrip.Outbound;
  }
};

// Frontend to Backend mapping
export const mapFrontToBackState = (frontState: string): string => {
  switch (frontState) {
    case 'Traité':
      return 'Processed';
    case 'En cours':
      return 'In_progress';
    case 'Non traité':
      return 'Unprocessed';
    case 'Annulé':
      return 'Cancelled';
    default:
      return 'Unprocessed';
  }
};

// Backend to Frontend mapping
export const mapBackToFrontState = (backState: string): string => {
  switch (backState) {
    case 'Processed':
      return 'Traité';
    case 'In_progress':
      return 'En cours';
    case 'Unprocessed':
      return 'Non traité';
    case 'Cancelled':
      return 'Annulé';
    default:
      return 'Non traité';
  }
};
