import { AddressData } from "./common";
import { EtatTrajet } from "./trajet";

export type ICircuit = {
    id: string,
    etat: string,
    codeCircuit: string,
    intitule: string,
    clientDO: string,
    chauffeur: string,
    type: string,
    dateDebut: string,
    dateDernierAvenant: string,
    dateFin: string,
    etablissement: string,
    adresseEtablissement: AddressData,
    numeroContrat: string,
    societe: string,
    isActive:boolean;
    typeCalcul?:string;
    grillePrix?:string;
    colorCode?:string;
    observation?: string;
    numeroLot: string;
    dureeTrajet?:string;
  };

  export type IcircuitTrajet = {
    id: string,
    numeroTrajet: string;
    preparation: string;
    dateDebut: string;
    intitule: string;
    sensAR: Sens;
    ets: string;
    kmEtTemps: string;
    usagers: string[];
    codeTrajetCircuit: string;
    circuit: string;
    etat: EtatTrajet;
    chauffeur: string;
  }

  export interface IAvenant {
    id: string;
    dateApplication: string;
    etat: string;
    codeCircuit: string;
    codeAvenant: string;
    intitule: string;
    objetAvenant: string;
    type: string;
    dateFin: string;
    etablissement: string;
    chauffeur: string;
    societe: string;
    clientDO: string;
    isActive:boolean;
    objet?: string;
    typeCalcul?: string;

  }

  export enum Sens {
    Aller = 'aller',
    Retour = 'retour',
  }
  export enum Etat {
    NonControle = 'non_controle',
    Controle = 'controle',
  }

  export interface ICircuitContract {
    id: string;
    numeroContrat: string;
    contrat: string;
    circuit: string;
    numeroLot: string[];
    isActive?: boolean;
  }

  export type IPreparationCircuit = {
    id: string,
    codeCircuit: string,
    intitule: string,
    dateDebut: string,
    dateFin: string,
    etablissement: string,
    etat?: string,
    kmAVide?: string,
    typeCalcul?: string,
    adresseEtablissement: AddressData,
    colorCode?: string,
    toll?: string,
    usagers?: string[],
    observation?: string,
  };
