export enum PeriodType {
    Matin = 'MATIN',
    Midi = 'MIDI',
    ApresMidi = 'APRES_MIDI',
    Soir = 'SOIR',
  }
 
  export type DriverRoute = {
    id: number;
    type: PeriodType;
    startHour: Date;
    endHour: Date;
    description: string;
  };
  
  export type MileageInterval = {
    id: number;
    startMileage: number;
    endMileage: number;
  };
  
  export type WorkedDay = {
    id: number;
    date: Date;
    fuelAmount: number;
    observation: string;
    driverRouteList: DriverRoute[];
    mileageIntervall: MileageInterval;
  };
  
    export type DriverRouteSheet = {
      id: number;
      date: Date;
      name: string;
      isSubmitted: boolean;
      workedDays: WorkedDay[];
    };
  export  interface IRoadMapMileage {
  startMileage: number | undefined;
  endMileage: number | undefined;
  fuelAmount: number | undefined;
}
