import React from 'react';
import AppBar from '@mui/material/AppBar';
import Toolbar from '@mui/material/Toolbar';
import Typography from '@mui/material/Typography';
import { alpha, Box } from '@mui/material';
import { HEADER, NAV } from '../config-layout';
import { useNavBar } from '@/contexts/settings/nav-bar-context';
import { useResponsive } from '@/hooks';
import Chatbot from '@/shared/components/chatbot/chatbot';

export default function Footer() {

  return (
    <>
        <Chatbot />
        <Box
          component="span"
          sx={{
            bgcolor: 'transparent',
            position: 'fixed',
            bottom:0
          }}
        >
          <Typography
            variant="body2"
            sx={{
              fontFamily: 'Inter-Regular, Helvetica, Arial, sans-serif',
              fontWeight: 'normal',
              color: (theme) => theme.palette.grey[600],
              fontSize: '0.875rem',
            }}
          >
            © 2025 VSN. All Rights Reserved
          </Typography>
        </Box>
    </>
  );
}
