import { TableColumn } from "../types/common";
import { IAgent } from "../types/agent";
import { ADRESSE, INITIAL_ADDRESS, MOCK_ADDRESSES } from ".";
import { IRole } from "../types/role";
import { RoleStatus } from "../api/stores/roleStore";

export const _AGENT_STATUS = [
  { value: "approved", label: "Approuvé" },
  { value: "pending", label: "En attente" },
  { value: "banned", label: "Banni" },
  { value: "deleted", label: "Supprimé" },
];

export const DEFAULT_AGENT_TABLE_HEAD: TableColumn[] = [
  { id: 'lastName', label: 'Nom', type: 'text' },
  { id: 'firstName', label: 'Prénom', type: 'text' },
  { id: 'role', label: 'Rôle', type: 'text' },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'address', label: 'Adresse', type: 'text' },
  { id: 'email', label: 'E-mail', type: 'text' },
  { id: 'phone', label: 'Téléphone', type: 'text' },
  { id: '', label: 'Actions' },
];

export const INITIAL_AGENT_DATA: IAgent = {
  id: '',
  lastName: '',
  firstName: '',
  birthDate: '',
  birthPlace: '',
  address:INITIAL_ADDRESS,
  phone: '',
  email: '',
  socialSecurityNumber: '',
  agentId: '',
  agency: '',
  password: '',
  department: '',
  contractType: '',
  status: 'pending',
  roles: [],
  permissions: [],
  isActive: true,
  team: '',
};

const FRENCH_NAMES = {
  lastNames: [
    'Dubois', 'Martin', 'Bernard', 'Thomas', 'Petit', 'Robert', 'Richard', 
    'Durand', 'Leroy', 'Moreau', 'Simon', 'Laurent', 'Lefebvre', 'Michel',
    'Garcia', 'David', 'Bertrand', 'Roux', 'Vincent', 'Fournier'
  ],
  firstNames: [
    'Emma', 'Lucas', 'Léa', 'Louis', 'Chloé', 'Hugo', 'Inès', 'Gabriel',
    'Alice', 'Jules', 'Louise', 'Arthur', 'Lina', 'Paul', 'Rose', 'Nathan',
    'Camille', 'Adam', 'Léna', 'Raphaël'
  ],
  cities: [
    'Paris', 'Lyon', 'Marseille', 'Bordeaux', 'Lille', 'Toulouse', 'Nantes',
    'Strasbourg', 'Montpellier', 'Nice', 'Rennes', 'Grenoble', 'Angers',
    'Dijon', 'Le Mans', 'Clermont-Ferrand', 'Amiens', 'Caen', 'Limoges', 'Metz'
  ],
  streets: [
    'rue de la République', 'avenue des Champs-Élysées', 'boulevard Saint-Michel',
    'rue de la Paix', 'avenue Victor Hugo', 'rue du Commerce', 'boulevard Haussmann',
    'rue de Rivoli', 'avenue Foch', 'rue Lafayette'
  ],
  agencies: [
    'Agence Centrale', 'Agence Nord', 'Agence Sud', 'Agence Est', 'Agence Ouest'
  ],
  departments: [
    'Commercial', 'Ressources Humaines', 'Comptabilité', 'Technique'
  ]
};
const AVAILABLE_ROLES: IRole[] = [
  { id: '1', name: 'Admin', description: 'Administrateur', status: RoleStatus.ENABLED, createdAt: new Date().toISOString(), permissions: ['ALL'],modules: [
    {
      date: "2025-06-10",
      module: "dashboard",
      permissions: ["view", "edit"],
    }] },
  { id: '2', name: 'Manager', description: 'Manager', status:RoleStatus.ENABLED, createdAt: new Date().toISOString(), permissions: ['READ', 'WRITE', 'UPDATE'] ,modules: [
    {
      date: "2025-06-10",
      module: "dashboard",
      permissions: ["view", "edit"],
    }] },
  { id: '3', name: 'Agent', description: 'Agent', status:RoleStatus.ENABLED, createdAt: new Date().toISOString(), permissions: ['READ', 'WRITE'],modules: [
    {
      date: "2025-06-10",
      module: "dashboard",
      permissions: ["view", "edit"],
    }]  }
];

// Mock data generation...
export const _agents = [...Array(20)].map((_, index) => {
  const roleIndex = index % 3;
  const selectedRole = AVAILABLE_ROLES[roleIndex];
  const connectionHistory = [...Array(5)].map((_, i) => {
    const date = new Date();
    date.setDate(date.getDate() - i);
    const startTime = new Date(date);
   
   
    startTime.setHours(8 + Math.floor(Math.random() * 2), Math.floor(Math.random() * 60), 0);
    
    const endTime = new Date(startTime);
    const duration = 480 + Math.floor(Math.random() * 120);
    endTime.setMinutes(endTime.getMinutes() + duration);

    return {
      id: `CONN-${index}-${i}`,
      startTime: startTime.toISOString(),
      endTime: endTime.toISOString(),
      duration: duration,
      date: date.toISOString().split('T')[0],
    };
  });
  
  const lastName = FRENCH_NAMES.lastNames[index % FRENCH_NAMES.lastNames.length];
  const firstName = FRENCH_NAMES.firstNames[index % FRENCH_NAMES.firstNames.length];
  const teamIndex = Math.floor(Math.random() * 5);

  return {
    id: `AG${(index + 1).toString().padStart(5, '0')}`,
    lastName,
    firstName,
    birthDate: new Date(1980 + (index % 20), index % 12, 15).toISOString().split('T')[0],
    birthPlace: FRENCH_NAMES.cities[Math.floor(Math.random() * FRENCH_NAMES.cities.length)],
    address: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    phone: `+33${Math.floor(Math.random() * 900000000 + 100000000)}`,
    email: `${firstName.toLowerCase()}.${lastName.toLowerCase()}@example.com`,
    personalEmail: `${firstName.toLowerCase()}.${lastName.toLowerCase()}@gmail.com`,
    socialSecurityNumber: `${Math.floor(Math.random() * 1000000000)}`,
    agentId: `AGT${(index + 1).toString().padStart(5, '0')}`,
    agency: FRENCH_NAMES.agencies[index % FRENCH_NAMES.agencies.length],
    password: 'Password123!',
    roles: [selectedRole], 
  
    department: FRENCH_NAMES.departments[index % FRENCH_NAMES.departments.length],
    team: index % 3 === 0 ? `TM${(12345 + teamIndex).toString().padStart(5, '0')}` : '',
    contractType: ['CDI', 'CDD', 'Intérim'][index % 3],
    status: _AGENT_STATUS[index % _AGENT_STATUS.length].value,
    role: ['Admin', 'Manager', 'Agent'][index % 3],
    permissions: ['Lecture', 'Écriture', 'Modification', 'Suppression'].slice(0, index % 4 + 1),
    isActive: Math.random() > 0.2,
    connectionHistory,
  };
});