import { TableColumn } from "../types/common";
import { Etat, IAvenant } from "../types/circuit";
import { SelectedDaysType } from "../types/usager";
import dayjs from "dayjs";
import { WeeklyScheduleType } from "../sections/usager/components/usager-form/avenants-horaires/horaires-specifique-tabs";

export const _AVENANT_TYPE_MODIFICATIONS = [
  "Changement d'adresse",
  "Modification de planning",
  "Changement de chauffeur",
  "Modification de tarif",
];

export const _AVENANT_TYPE_GENERATION = [
  "automatique",
  "manuel",
];

export const _avenants =  (isSecondaryTable: boolean) => [...Array(50)].map((_, index) => {
    const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
    const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
    const typeOption = isSecondaryTable ?_AVENANT_TYPE_MODIFICATIONS : _AVENANT_TYPE_GENERATION
  return {
    id: (index + 1).toString(),
    dateApplication: startDate.toISOString().split('T')[0],
    etat: index % 3 === 0 ? Etat.Controle : Etat.NonControle,
    codeAvenant: `AVE-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`,
    codeCircuit: `CIR-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`,
    intitule: `Avenant ${index + 1}`,
    objetAvenant: ["Adresse Domicile", "Horaires", "Véhicule", "Tarification"][index % 4],
    type: typeOption[index % typeOption.length],
    dateFin: endDate.toISOString().split('T')[0],
    etablissement: ['Les Champs', 'La Colline', 'Le Rivage', 'La Forêt'][index % 4],
    chauffeur: Math.random() > 0.3 ? `Chauffeur ${index + 1}` : "Non Affecté",
    societe: `Région ${['Est', 'Ouest', 'Nord', 'Sud'][index % 4]}`,
    clientDO: `DO ${['Nord', 'Sud', 'Est', 'Ouest'][index % 4]}`,
    isActive: Math.random() < 0.6,
    objet: "Transport Scolaire",
  };
});


export const DEFAULT_AVENANT_CIRCUIT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Avenant', type: 'text', align: 'center' },
  { id: 'dateApplication', label: 'A partir du', type: 'date', align: 'center' },
  { id: 'etat', label: 'État', type: 'status', align: 'left' },
  { id: 'codeCircuit', label: 'Code', type: 'text', align: 'left' },
  { id: 'intitule', label: 'Intitulé', type: 'text', align: 'left' },
  { id: 'objetAvenant', label: 'Objet de l\'avenant', type: 'text', align: 'left' },
  { id: 'type', label: 'Type', type: 'text', align: 'left' },
  { id: 'dateFin', label: 'Fin de circuit', type: 'date', align: 'center' },
  { id: 'etablissement', label: 'Établissement', type: 'text', align: 'left' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'societe', label: 'Société', type: 'text', align: 'left' },
  { id: 'clientDO', label: 'Client DO', type: 'text', align: 'left' },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: '', label: 'Action' },
];

export const DEFAULT_AVENANT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Avenant', type: 'text', align: 'center' },
  { id: 'dateApplication', label: 'Date de création', type: 'date', align: 'center' },
  { id: 'etat', label: 'État', type: 'status', align: 'left' },
  { id: 'codeAvenant', label: 'Code Avenant', type: 'text', align: 'left' },
  { id: 'intitule', label: 'Intitulé', type: 'text', align: 'left' },
  { id: 'clientDO', label: 'Client DO', type: 'text', align: 'left' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'societe', label: 'Société', type: 'text', align: 'left' },
  { id: 'objetAvenant', label: 'Objet de l\'avenant', type: 'text', align: 'left' },
  { id: 'objet', label: 'Objet', type: 'text', align: 'left' },
  { id: 'type', label: 'Type', type: 'text', align: 'left' },
  { id: 'dateFin', label: 'Fin de circuit', type: 'date', align: 'center' },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: '', label: 'Action' },
];

export const INITIAL_AVENANT_DATA: IAvenant = {
  id: '',
  dateApplication: '',
  etat: 'non_controle',
  codeCircuit: '',
  codeAvenant: '',
  intitule: '',
  objetAvenant: '',
  type: '',
  dateFin: '',
  etablissement: '',
  chauffeur: '',
  societe: '',
  clientDO: '',
  isActive: true,
  objet: '',
};

export const MOCKED_SCHEDULE_DATA: WeeklyScheduleType = {
  pair: {
    lundi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },    mardi:  { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    }, 
    mercredi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    jeudi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    vendredi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    samedi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    dimanche: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
  },
  impair: {
    lundi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    mardi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    mercredi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    jeudi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    vendredi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    samedi: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
    dimanche: { 
      morning: { aller: dayjs().hour(8).minute(0) },
      evening: { retour: dayjs().hour(18).minute(0) }
    },
  },
}
