import { TableColumn } from '../types/common';
import { CandidatureStatut, ICandidature, INITIAL_CANDIDATURE_DATA } from '../types/candidature';
import { MOCK_ADDRESSES } from '.';

// Define a simple counter for generating IDs
let idCounter = 0;

// Function to generate a new ID
function generateSimpleId() {
  return (idCounter++).toString();
}

export const DEFAULT_CANDIDATURE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'suiviAppel', label: 'Suivi d\'appel', align: 'left', type: 'text' },
  { id: 'dateAppelRappel', label: 'Date appel ou rappel', align: 'left', type: 'date' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'aProximite', label: 'A proximité du circuit', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_RETENUS_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Date et heure RDV agence', align: 'left', type: 'datetime' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'aProximite', label: 'A proximité du circuit', align: 'left', type: 'text' },
  { id: 'document', label: 'Document', align: 'center', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_RETENUS_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Date et heure RDV agence', align: 'left', type: 'datetime' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_RETENUS_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_RDV_SEMAINE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Date et heure RDV agence', align: 'left', type: 'datetime' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' }
];

export const DEFAULT_CANDIDATURE_RDV_SEMAINE_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Date et heure RDV agence', align: 'left', type: 'datetime' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_RDV_SEMAINE_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_ABSENT_RDV_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'dureePermis', label: 'Durée de permis', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Replanifier un RDV', align: 'left', type: 'datetime' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_ABSENT_RDV_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'dureePermis', label: 'Durée de permis', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Replanifier un RDV', align: 'left', type: 'datetime' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_ABSENT_RDV_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'dateHeureRdvAgence', label: 'Replanifier un RDV', align: 'left', type: 'datetime' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_TABLEAU_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'aProximite', label: 'A proximité du circuit', align: 'left', type: 'text' },
  { id: 'contrat', label: 'Contrat', align: 'center', type: 'text' },
  { id: 'document', label: 'Document', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_TABLEAU_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'email_pro', label: 'Email Pro', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'dureePermis', label: 'Durée de permis', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'proximiteCircuit', label: 'A proximité du circuit', align: 'left', type: 'text' },
  { id: 'contrat', label: 'Contrat', align: 'center', type: 'text' },
  { id: 'document', label: 'Document', align: 'center', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_TABLEAU_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'email_pro', label: 'Email Pro', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'contrat', label: 'Contrat', align: 'center', type: 'text' },
  { id: 'document', label: 'Document', align: 'center', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_TOUS_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'type', label: 'Type', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'dureePermis', label: 'Durée de permis', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: 'raisonRefus', label: 'Raison', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_TOUS_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: 'raisonRefus', label: 'Raison', align: 'left', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_REFUSES_BLACKLISTES_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'raisonRefus', label: 'Raison', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_REFUSES_BLACKLISTES_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'raisonRefus', label: 'Raison', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

export const DEFAULT_CANDIDATURE_SEDENTAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', align: 'left', type: 'text' },
  { id: 'nom', label: 'Nom & Prénom', align: 'left', type: 'text' },
  { id: 'sourceCandidat', label: 'Source candidat', align: 'left', type: 'text' },
  { id: 'codePostal', label: 'Code Postal', align: 'left', type: 'text' },
  { id: 'ville', label: 'Ville', align: 'left', type: 'text' },
  { id: 'age', label: 'Age', align: 'left', type: 'text' },
  { id: 'email', label: 'Email', align: 'left', type: 'text' },
  { id: 'telephone', label: 'Téléphone', align: 'left', type: 'text' },
  { id: 'suiviAppel', label: 'Suivi d\'appel', align: 'left', type: 'text' },
  { id: 'dateAppelRappel', label: 'Date appel ou rappel', align: 'left', type: 'date' },
  { id: 'dateCandidature', label: 'Date de candidature', align: 'left', type: 'date' },
  { id: 'departement', label: 'Département', align: 'left', type: 'text' },
  { id: 'statut', label: 'Statut', align: 'center', type: 'text' },
  { id: 'document', label: 'Document', align: 'center', type: 'text' },
  { id: '', label: 'Action', type: 'action', align: 'center' }
];

// Mock data for candidatures
export const _candidatures: ICandidature[] = [
  {
    id: generateSimpleId(),
    nom: 'Dupont',
    prenom: 'Jean',
    sourceCandidat: 'Indeed',
    codePostal: '75001',
    ville: 'Paris',
    departement: 'Paris',
    age: 35,
    email: 'jean.dupont@example.com',
    telephone: '0612345678',
    dureePermis: '10 ans',
    suiviAppel: 'Premier contact',
    dateAppelRappel: '2023-05-15',
    dateCandidature: '2023-05-10',
    statut: CandidatureStatut.ATraiter,
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Martin',
    prenom: 'Sophie',
    sourceCandidat: 'LinkedIn',
    codePostal: '69001',
    ville: 'Lyon',
    departement: 'Rhône',
    age: 28,
    email: 'sophie.martin@example.com',
    telephone: '0623456789',
    dureePermis: '5 ans',
    suiviAppel: 'Entretien téléphonique',
    dateAppelRappel: '2023-05-18',
    dateCandidature: '2023-05-12',
    statut: CandidatureStatut.EnCours,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]

  },
  {
    id: generateSimpleId(),
    nom: 'Dubois',
    prenom: 'Pierre',
    sourceCandidat: 'Pôle Emploi',
    codePostal: '33000',
    ville: 'Bordeaux',
    departement: 'Gironde',
    age: 42,
    email: 'pierre.dubois@example.com',
    telephone: '0634567890',
    dureePermis: '20 ans',
    suiviAppel: 'Deuxième entretien',
    dateAppelRappel: '2023-05-20',
    dateCandidature: '2023-05-08',
    statut: CandidatureStatut.Retenu,
    dateHeureRdvAgence: '2023-05-25T10:00',
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]

  },
  {
    id: generateSimpleId(),
    nom: 'Leroy',
    prenom: 'Marie',
    sourceCandidat: 'Site web',
    codePostal: '59000',
    ville: 'Lille',
    departement: 'Nord',
    age: 31,
    email: 'marie.leroy@example.com',
    telephone: '0645678901',
    dureePermis: '8 ans',
    suiviAppel: 'Entretien physique',
    dateAppelRappel: '2023-05-22',
    dateCandidature: '2023-05-15',
    statut: CandidatureStatut.Valide,
    dateHeureRdvAgence: '2023-05-25T10:00',
    type: 'Candidature sédentaire',
    contrat: 'signé',
    email_pro: 'marie.leroy@votreentreprise.com',
    contrat_document: 'contrat_marie_leroy.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Moreau',
    prenom: 'Thomas',
    sourceCandidat: 'Indeed',
    codePostal: '44000',
    ville: 'Nantes',
    departement: 'Loire-Atlantique',
    age: 38,
    email: 'thomas.moreau@example.com',
    telephone: '0656789012',
    dureePermis: '15 ans',
    suiviAppel: 'Non joignable',
    dateAppelRappel: '2023-05-16',
    dateCandidature: '2023-05-05',
    statut: CandidatureStatut.Refuse,
    raisonRefus: 'Profil ne correspondant pas aux critères',
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Petit',
    prenom: 'Julie',
    sourceCandidat: 'LinkedIn',
    codePostal: '67000',
    ville: 'Strasbourg',
    departement: 'Bas-Rhin',
    age: 29,
    email: 'julie.petit@example.com',
    telephone: '0667890123',
    dureePermis: '6 ans',
    suiviAppel: 'Rappeler',
    dateAppelRappel: '2023-05-25',
    dateCandidature: '2023-05-18',
    statut: CandidatureStatut.ATraiter,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Roux',
    prenom: 'Nicolas',
    sourceCandidat: 'Recommandation',
    codePostal: '13001',
    ville: 'Marseille',
    departement: 'Bouches-du-Rhône',
    age: 45,
    email: 'nicolas.roux@example.com',
    telephone: '0678901234',
    dureePermis: '22 ans',
    suiviAppel: 'Entretien programmé',
    dateAppelRappel: '2023-05-19',
    dateCandidature: '2023-05-14',
    statut: CandidatureStatut.Retenu,
    dateHeureRdvAgence: '2023-05-26T14:30',
    type: 'Candidature chauffeur',
    email_pro: 'nicolas.roux@votreentreprise.com',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Fournier',
    prenom: 'Camille',
    sourceCandidat: 'Indeed',
    codePostal: '31000',
    ville: 'Toulouse',
    departement: 'Haute-Garonne',
    age: 33,
    email: 'camille.fournier@example.com',
    telephone: '0689012345',
    dureePermis: '10 ans',
    suiviAppel: 'Entretien téléphonique',
    dateAppelRappel: '2023-05-21',
    dateCandidature: '2023-05-16',
    statut: CandidatureStatut.Absent,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Bernard',
    prenom: 'Alice',
    sourceCandidat: 'Indeed',
    codePostal: '75002',
    ville: 'Paris',
    departement: 'Paris',
    age: 30,
    email: 'alice.bernard@example.com',
    telephone: '0612345679',
    dureePermis: '12 ans',
    suiviAppel: 'Premier contact',
    dateAppelRappel: '2023-06-01',
    dateCandidature: '2023-05-30',
    statut: CandidatureStatut.ATraiter,
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Durand',
    prenom: 'Luc',
    sourceCandidat: 'LinkedIn',
    codePostal: '69002',
    ville: 'Lyon',
    departement: 'Rhône',
    age: 40,
    email: 'luc.durand@example.com',
    telephone: '0623456790',
    dureePermis: '15 ans',
    suiviAppel: 'Entretien téléphonique',
    dateAppelRappel: '2023-06-02',
    dateCandidature: '2023-05-29',
    statut: CandidatureStatut.EnCours,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Morel',
    prenom: 'Emma',
    sourceCandidat: 'Pôle Emploi',
    codePostal: '33001',
    ville: 'Bordeaux',
    departement: 'Gironde',
    age: 25,
    email: 'emma.morel@example.com',
    telephone: '0634567901',
    dureePermis: '3 ans',
    suiviAppel: 'Deuxième entretien',
    dateAppelRappel: '2023-06-03',
    dateCandidature: '2023-05-28',
    statut: CandidatureStatut.Retenu,
    dateHeureRdvAgence: '2023-06-05T09:00',
    type: 'Candidature chauffeur',
    email_pro: 'emma.morel@votreentreprise.com',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Lefevre',
    prenom: 'Paul',
    sourceCandidat: 'Site web',
    codePostal: '59001',
    ville: 'Lille',
    departement: 'Nord',
    age: 35,
    email: 'paul.lefevre@example.com',
    telephone: '0645679012',
    dureePermis: '10 ans',
    suiviAppel: 'Entretien physique',
    dateAppelRappel: '2023-06-04',
    dateCandidature: '2023-05-27',
    statut: CandidatureStatut.Valide,
    dateHeureRdvAgence: '2023-06-05T09:00',
    type: 'Candidature chauffeur',
    contrat: 'non signé',
    email_pro: 'paul.lefevre@votreentreprise.com',
    contrat_document: 'contrat_paul_lefevre.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Simon',
    prenom: 'Chloe',
    sourceCandidat: 'Indeed',
    codePostal: '44001',
    ville: 'Nantes',
    departement: 'Loire-Atlantique',
    age: 28,
    email: 'chloe.simon@example.com',
    telephone: '0656789023',
    dureePermis: '7 ans',
    suiviAppel: 'Non joignable',
    dateAppelRappel: '2023-06-05',
    dateCandidature: '2023-05-26',
    statut: CandidatureStatut.Refuse,
    raisonRefus: 'Profil ne correspondant pas aux critères',
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Renaud',
    prenom: 'Julien',
    sourceCandidat: 'LinkedIn',
    codePostal: '67001',
    ville: 'Strasbourg',
    departement: 'Bas-Rhin',
    age: 32,
    email: 'julien.renaud@example.com',
    telephone: '0667890124',
    dureePermis: '8 ans',
    suiviAppel: 'Rappeler',
    dateAppelRappel: '2023-06-06',
    dateCandidature: '2023-05-25',
    statut: CandidatureStatut.Blackliste,
    raisonRefus: 'Comportement inapproprié lors de l\'entretien téléphonique',
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Giraud',
    prenom: 'Sophie',
    sourceCandidat: 'Recommandation',
    codePostal: '13002',
    ville: 'Marseille',
    departement: 'Bouches-du-Rhône',
    age: 45,
    email: 'sophie.giraud@example.com',
    telephone: '0678901235',
    dureePermis: '20 ans',
    suiviAppel: 'Entretien programmé',
    dateAppelRappel: '2023-06-07',
    dateCandidature: '2023-05-24',
    statut: CandidatureStatut.Absent,
    type: 'Candidature sédentaire',
    contrat: 'signé',
    email_pro: 'sophie.giraud@votreentreprise.com',
    contrat_document: 'contrat_sophie_giraud.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Giraud',
    prenom: 'Sophie',
    sourceCandidat: 'Recommandation',
    codePostal: '13002',
    ville: 'Marseille',
    departement: 'Bouches-du-Rhône',
    age: 45,
    email: 'sophie.giraud@example.com',
    telephone: '0678901235',
    dureePermis: '20 ans',
    suiviAppel: 'Entretien programmé',
    dateAppelRappel: '2023-06-07',
    dateCandidature: '2023-05-24',
    statut: CandidatureStatut.Valide,
    dateHeureRdvAgence: '2023-06-05T09:00',
    type: 'Candidature sédentaire',
    contrat: 'signé',
    email_pro: 'sophie.giraud@votreentreprise.com',
    contrat_document: 'contrat_sophie_giraud.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Lambert',
    prenom: 'Mathieu',
    sourceCandidat: 'Indeed',
    codePostal: '75012',
    ville: 'Paris',
    departement: 'Paris',
    age: 39,
    email: 'mathieu.lambert@example.com',
    telephone: '0612398765',
    dureePermis: '18 ans',
    suiviAppel: 'Premier contact',
    dateAppelRappel: '2023-06-20',
    dateCandidature: '2023-06-15',
    statut: CandidatureStatut.ATraiter,
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Rousseau',
    prenom: 'Philippe',
    sourceCandidat: 'Le Bon Coin',
    codePostal: '93100',
    ville: 'Montreuil',
    departement: 'Paris',
    age: 45,
    email: 'philippe.rousseau@example.com',
    telephone: '0645678923',
    dureePermis: '23 ans',
    suiviAppel: 'Entretien programmé',
    dateAppelRappel: '2023-06-25',
    dateCandidature: '2023-06-18',
    statut: CandidatureStatut.EnCours,
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Marchand',
    prenom: 'David',
    sourceCandidat: 'Pôle Emploi',
    codePostal: '69003',
    ville: 'Lyon',
    departement: 'Rhône',
    age: 32,
    email: 'david.marchand@example.com',
    telephone: '0678912356',
    dureePermis: '10 ans',
    suiviAppel: 'Deuxième entretien',
    dateAppelRappel: '2023-06-28',
    dateCandidature: '2023-06-20',
    statut: CandidatureStatut.Retenu,
    dateHeureRdvAgence: '2023-07-05T11:30',
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Brun',
    prenom: 'Alexandre',
    sourceCandidat: 'Indeed',
    codePostal: '31500',
    ville: 'Toulouse',
    departement: 'Haute-Garonne',
    age: 37,
    email: 'alexandre.brun@example.com',
    telephone: '0656781234',
    dureePermis: '15 ans',
    suiviAppel: 'Évaluation terminée',
    dateAppelRappel: '2023-06-15',
    dateCandidature: '2023-06-05',
    statut: CandidatureStatut.Valide,
    dateHeureRdvAgence: '2023-06-05T09:00',
    type: 'Candidature chauffeur',
    contrat: 'non signé',
    email_pro: 'alexandre.brun@votreentreprise.com',
    contrat_document: 'contrat_alexandre_brun.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Legrand',
    prenom: 'Thierry',
    sourceCandidat: 'Recommandation',
    codePostal: '44200',
    ville: 'Nantes',
    departement: 'Loire-Atlantique',
    age: 41,
    email: 'thierry.legrand@example.com',
    telephone: '0643219876',
    dureePermis: '20 ans',
    suiviAppel: 'Non joignable',
    dateAppelRappel: '2023-06-12',
    dateCandidature: '2023-06-01',
    statut: CandidatureStatut.Absent,
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Gauthier',
    prenom: 'Fabien',
    sourceCandidat: 'LinkedIn',
    codePostal: '59800',
    ville: 'Lille',
    departement: 'Nord',
    age: 34,
    email: 'fabien.gauthier@example.com',
    telephone: '0689076543',
    dureePermis: '12 ans',
    suiviAppel: 'Candidature incomplète',
    dateAppelRappel: '2023-06-08',
    dateCandidature: '2023-06-02',
    statut: CandidatureStatut.Refuse,
    raisonRefus: 'Expérience insuffisante',
    type: 'Candidature chauffeur',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Perrin',
    prenom: 'Caroline',
    sourceCandidat: 'LinkedIn',
    codePostal: '75015',
    ville: 'Paris',
    departement: 'Paris',
    age: 29,
    email: 'caroline.perrin@example.com',
    telephone: '0678901234',
    dureePermis: '8 ans',
    suiviAppel: 'Premier contact',
    dateAppelRappel: '2023-06-22',
    dateCandidature: '2023-06-17',
    statut: CandidatureStatut.ATraiter,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Blanc',
    prenom: 'Nathalie',
    sourceCandidat: 'Welcome to the Jungle',
    codePostal: '69007',
    ville: 'Lyon',
    departement: 'Rhône',
    age: 31,
    email: 'nathalie.blanc@example.com',
    telephone: '0612345987',
    dureePermis: '10 ans',
    suiviAppel: 'Entretien programmé',
    dateAppelRappel: '2023-06-26',
    dateCandidature: '2023-06-19',
    statut: CandidatureStatut.EnCours,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Morin',
    prenom: 'Aurélie',
    sourceCandidat: 'Indeed',
    codePostal: '33000',
    ville: 'Bordeaux',
    departement: 'Gironde',
    age: 27,
    email: 'aurelie.morin@example.com',
    telephone: '0654328976',
    dureePermis: '5 ans',
    suiviAppel: 'Deuxième entretien',
    dateAppelRappel: '2023-06-29',
    dateCandidature: '2023-06-21',
    statut: CandidatureStatut.Retenu,
    dateHeureRdvAgence: '2023-07-06T14:00',
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Guerin',
    prenom: 'Céline',
    sourceCandidat: 'Pôle Emploi',
    codePostal: '13008',
    ville: 'Marseille',
    departement: 'Bouches-du-Rhône',
    age: 35,
    email: 'celine.guerin@example.com',
    telephone: '0687654321',
    dureePermis: '14 ans',
    suiviAppel: 'Évaluation terminée',
    dateAppelRappel: '2023-06-14',
    dateCandidature: '2023-06-04',
    statut: CandidatureStatut.Valide,
    dateHeureRdvAgence: '2023-06-05T09:00',
    type: 'Candidature sédentaire',
    email_pro: 'celine.guerin@votreentreprise.com',
    contrat_document: 'contrat_celine_guerin.pdf',
    address: MOCK_ADDRESSES[0]
  },
  {
    id: generateSimpleId(),
    nom: 'Faure',
    prenom: 'Isabelle',
    sourceCandidat: 'Site web',
    codePostal: '31400',
    ville: 'Toulouse',
    departement: 'Haute-Garonne',
    age: 38,
    email: 'isabelle.faure@example.com',
    telephone: '0621987654',
    dureePermis: '17 ans',
    suiviAppel: 'Non joignable',
    dateAppelRappel: '2023-06-11',
    dateCandidature: '2023-06-03',
    statut: CandidatureStatut.Absent,
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]

  },
  {
    id: generateSimpleId(),
    nom: 'Lemaire',
    prenom: 'Sandrine',
    sourceCandidat: 'Apec',
    codePostal: '44300',
    ville: 'Nantes',
    departement: 'Loire-Atlantique',
    age: 42,
    email: 'sandrine.lemaire@example.com',
    telephone: '0698765432',
    dureePermis: '21 ans',
    suiviAppel: 'Candidature non adaptée',
    dateAppelRappel: '2023-06-07',
    dateCandidature: '2023-06-01',
    statut: CandidatureStatut.Refuse,
    raisonRefus: 'Profil ne correspondant pas au poste',
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]

  },
  {
    id: generateSimpleId(),
    nom: 'Roche',
    prenom: 'Stéphanie',
    sourceCandidat: 'LinkedIn',
    codePostal: '67000',
    ville: 'Strasbourg',
    departement: 'Bas-Rhin',
    age: 33,
    email: 'stephanie.roche@example.com',
    telephone: '0634567891',
    dureePermis: '11 ans',
    suiviAppel: 'Comportement inapproprié',
    dateAppelRappel: '2023-06-05',
    dateCandidature: '2023-05-30',
    statut: CandidatureStatut.Blackliste,
    raisonRefus: 'Attitude agressive lors de l\'entretien',
    type: 'Candidature sédentaire',
    address: MOCK_ADDRESSES[0]

  }
];

export const _formulaires = [
  {
    id: generateSimpleId(),
    nom: 'Formulaire de candidature chauffeur',
    lien: 'https://forms.example.com/candidature-chauffeur',
    description: 'Formulaire pour les candidats au poste de chauffeur'
  },
  {
    id: generateSimpleId(),
    nom: 'Questionnaire de compétences',
    lien: 'https://forms.example.com/competences',
    description: 'Évaluation des compétences techniques et professionnelles'
  },
  {
    id: generateSimpleId(),
    nom: 'Formulaire d\'expérience de conduite',
    lien: 'https://forms.example.com/experience-conduite',
    description: 'Détails sur l\'expérience de conduite et les qualifications'
  }
];