import { TableColumn } from "../types/common";
import { IChauffeur, JoursAttribues, WeekDays, Interval } from "../types/chauffeur";

const randomTime = () => {
  const hours = Math.floor(Math.random() * 24).toString().padStart(2, '0');
  const minutes = Math.floor(Math.random() * 60).toString().padStart(2, '0');
  return `${hours}:${minutes}`;
};

const generateDaySchedule = (): { matin: boolean; soir: boolean } => ({
  matin: Math.random() > 0.5,
  soir: Math.random() > 0.5,
});

const generateWeekSchedule = (): WeekDays => ({
  lundi: generateDaySchedule(),
  mardi: generateDaySchedule(),
  mercredi: generateDaySchedule(),
  jeudi: generateDaySchedule(),
  vendredi: generateDaySchedule(),
  samedi: generateDaySchedule(),
  dimanche: generateDaySchedule(),
});

export const _chauffeurs: IChauffeur[] = [...Array(5)].map((_, index) => {
  const startTime = randomTime();
  const endTime = randomTime();
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  const joursAttribues: JoursAttribues = {
    pair: generateWeekSchedule(),
    impair: generateWeekSchedule(),
  };

  const trajet: Interval = {
    depart: `${['Collège', 'École', 'Lycée'][Math.floor(Math.random() * 3)]} ${String.fromCharCode(65 + index)}`,
    arriver: `${['École', 'Collège', 'Lycée'][Math.floor(Math.random() * 3)]} ${String.fromCharCode(75 + index)}`,
  };

  const horaires: Interval = {
    depart: startTime,
    arriver: endTime,
  };

  return {
    id: (index + 1).toString(),
    numeroChauffeur: `${(index + 1).toString().padStart(7, '0')}`,
    trajet,
    horaires,
    dateDebut: startDate.toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
    chauffeur: `${['Jean', 'Marie', 'Pierre', 'Sophie', 'Luc'][Math.floor(Math.random() * 5)]} ${['Dupont', 'Martin', 'Bernard', 'Petit', 'Durand'][Math.floor(Math.random() * 5)]}`,
    joursAttribues,
    observation: ['Trajet régulier', 'Modification ponctuelle', 'Remplacement temporaire'][Math.floor(Math.random() * 3)],
  };
});

export const DEFAULT_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroChauffeur', label: 'N° chauffeur', type: 'text', align: 'left' },
  { id: 'trajet', label: 'Trajet', type: 'text', align: 'left' },
  { id: 'horaires', label: 'Horaires', type: 'text', align: 'center' },
  { id: 'dateDebut', label: 'A partir du', type: 'date', align: 'center' },
  { id: 'dateFin', label: 'Jusqu\'au', type: 'date', align: 'center' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'joursAttribues', label: 'Jours attribués', type: 'text', align: 'center' },
  { id: 'observation', label: 'Observation', type: 'text', align: 'left' },
];

export const INITIAL_CHAUFFEUR_DATA: IChauffeur = {
  id: '',
  numeroChauffeur: '',
  trajet: { depart: '', arriver: '' },
  horaires: { depart: '', arriver: '' },
  dateDebut: '',
  dateFin: '',
  chauffeur: '',
  joursAttribues: {
    pair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
    impair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
  },
  observation: '',
};
