import { TableColumn } from "../types/common";
import { ICircuit, ICircuitContract } from "../types/circuit";
import { MOCK_ADDRESSES } from ".";

export const _CIRCUIT_STATUS = [
  { value: "controle", label: "Contrôlé" },
  { value: "non_controle", label: "Non Contrôlé" },
];

export const _TRAJET_DUREES = [
  { value: "15", label: "15 minutes" },
  { value: "30", label: "30 minutes" },
  { value: "45", label: "45 minutes" },
  { value: "60", label: "1 heure" },
  { value: "90", label: "1 heure 30" },
  { value: "120", label: "2 heures" },
  { value: "150", label: "2 heures 30" },
  { value: "180", label: "3 heures" },
  { value: "210", label: "3 heures 30" },
  { value: "240", label: "4 heures" },
  { value: "270", label: "4 heures 30" },
  { value: "300", label: "5 heures" },
];


export const _circuits = [...Array(55)].map((_, index) => {
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  const circuitCode = `CIR-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`;
  const mockAddress = MOCK_ADDRESSES[index % 4];
  
  return {
    id: (index + 1).toString(),
    etat: index % 3 === 0 ? 'controle' : 'non_controle',
    codeCircuit: circuitCode,
    intitule: `Ligne ${['Nord', 'Sud', 'Est', 'Ouest'][index % 4]}`,
    clientDO: `DO ${['Nord', 'Sud', 'Est', 'Ouest'][index % 4]}`,
    chauffeur: `Chauffeur ${index + 1}`,
    type: ['Bellevue', 'Montagne', 'Côte', 'Campagne'][index % 4],
    dateDebut: startDate.toISOString().split('T')[0],
    dateDernierAvenant: new Date(startDate.getTime() + Math.random() * (endDate.getTime() - startDate.getTime())).toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
    etablissement: ['Les Champs', 'La Colline', 'Le Rivage', 'La Forêt'][index % 4],
    adresseEtablissement: mockAddress,
    numeroContrat: `CT-${(index + 1).toString().padStart(5, '0')}`,
    societe: `Région ${['Est', 'Ouest', 'Nord', 'Sud'][index % 4]}`,
    numeroLot: `BCI${(256579345 + index).toString().padStart(9, '0')}`,
    isActive: Math.random() < 0.6,
    typeCalcul: '',
    colorCode: '',
  };
});

export const circuitOptions = _circuits.map((circuit) => ({
  label: `${circuit.intitule} (${circuit.codeCircuit})`,
  value: circuit.id
}));

export const getEtatLabel = (status: string): string => {
  const statusObj = _CIRCUIT_STATUS.find(s => s.value === status);
  return statusObj ? statusObj.label : "Inconnu";
};

export const DEFAULT_CIRCUIT_TABLE_HEAD : TableColumn[] = [
  { id: 'id', label: 'N° circuit', type: 'text',align: 'center' },
  { id: 'etat', label: 'État', type: 'status',align: 'left' },
  { id: 'codeCircuit', label: 'Code circuit', type: 'text',align: 'left' },
  { id: 'intitule', label: 'Intitulé', type: 'text',align: 'left' },
  { id: 'clientDO', label: 'Client DO', type: 'text',align: 'left' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text',align: 'left' },
  { id: 'type', label: 'Type', type: 'text',align: 'center' },
  { id: 'dateDebut', label: 'A partir du', type: 'date',align: 'center' },
  { id: 'dateDernierAvenant', label: 'Dernier avenant', type: 'date',align: 'center' },
  { id: 'dateFin', label: 'Fin de circuit', type: 'date',align: 'center' },
  { id: 'etablissement', label: 'Établissement', type: 'text',align: 'left' },
  { id: 'adresseEtablissement', label: 'Adresse établissement', type: 'text',align: 'left' },
  { id: 'numeroContrat', label: 'Contrat', type: 'text',align: 'left' },
  { id: 'societe', label: 'Société', type: 'text',align: 'left' },
  { id: 'numeroLot', label: 'N° de lot', type: 'text', align: 'left' },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: '', label: 'Action' },
];

export const INITIAL_CIRCUIT_DATA: ICircuit = {
  id: '',
  etat: 'non_controle',
  codeCircuit: '',
  intitule: '',
  clientDO: '',
  chauffeur: '',
  type: '',
  dateDebut: '',
  dateDernierAvenant: '',
  dateFin: '',
  etablissement: '',
  adresseEtablissement:{
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
  },
  numeroContrat: '',
  societe: '',
  numeroLot: '',
  typeCalcul: '',
  colorCode: '',
  isActive: true,
  dureeTrajet: '',
  observation: '',
};

// Mock data for contract-circuit relationships
export const _circuitsContract: ICircuitContract[] = [...Array(5)].map((_, index) => {
  return {
    id: (index + 1).toString(),
    numeroContrat: `CT-${(index + 1).toString().padStart(3, '0')}`,
    contrat: [
      'Contrat de Collaboration Commerciale',
      'Contrat de Transport Scolaire',
      'Contrat de Service Touristique',
      'Contrat de Transport Privé',
      'Contrat de Partenariat'
    ][Math.floor(Math.random() * 5)],
    circuit: [
      'Circuit Découverte : Barcelone - Santorin',
      'Circuit Culturel : Paris - Londres',
      'Circuit Scolaire : École Primaire Saint-Joseph',
      'Circuit Touristique : Costa del Sol',
      'Circuit Express : Lyon - Marseille'
    ][Math.floor(Math.random() * 5)],
    numeroLot:[`BCI${(256579345 + index).toString().padStart(9, '0')}`],
    isActive: false
  };
});

export const DEFAULT_CONTRACT_CIRCUIT_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroContrat', label: 'N° Contrat', type: 'text', align: 'left' },
  { id: 'contrat', label: 'Contrat', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'numeroLot', label: 'N° de lot', type: 'text', align: 'left' },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: '', label: 'Action' },
];

export const INITIAL_CONTRACT_CIRCUIT_DATA: ICircuitContract = {
  id: '',
  numeroContrat: '',
  contrat: '',
  circuit: '',
  numeroLot: [],
  isActive: false
};


