import type { TableColumn } from "../types/common"
import { DriverRoadMapStatus, type IDriver } from "../types/driver"
import { Civility } from "../types/usager";
import { _FUEL_TYPES } from "./flottes/_fuelFees";
import { _noms, _prenoms, FUEL_CARDS, generatePhoneNumber, INITIAL_ADDRESS, MOCK_ADDRESSES } from "."

export const _DRIVER_STATUS = [
  { value: "disponible", label: "Disponible" },
  { value: "absent", label: "Absent" },
];
export const _PERMIS_TYPE = [
  { value: "A", label: "A" },
  { value: "B", label: "B" },
  { value: "C", label: "C" },
  { value: "D", label: "D" },
];

export const DRIVER_STATUS_OPTIONS = [
  { value: DriverRoadMapStatus.Disponible, label: "Disponible" },
  { value: DriverRoadMapStatus.Affecte, label: "Affecté" },
  { value: DriverRoadMapStatus.Absent, label: "Absent" },
  { value: DriverRoadMapStatus.Suspendu, label: "Suspendu" },
  { value: DriverRoadMapStatus.NonDisponible, label: "Non disponible" },
]

export const VEHICLES = ["VSN89364", "KHT89364", "LMP74521", "WXY45678"]

export const _drivers: IDriver[] = [...Array(25)].map((_, index) => {
  const firstName = _prenoms[index % 4]
  const lastName = _noms[index % 4]
  const marketDate = new Date(2025 + Math.floor(index / 12), index % 12, 15);
  const  statusList = Object.values(DriverRoadMapStatus)
  return {
    id: (index + 1).toString(),
    firstName,
    lastName,
    vehicle: VEHICLES[index % VEHICLES.length],
    fuelCard: [FUEL_CARDS[index % FUEL_CARDS.length]],
    fuelType: [_FUEL_TYPES[index % _FUEL_TYPES.length],],
    fuelVolume: "1000 L",
    phone: generatePhoneNumber("+33"),
    email: `${lastName}@gmail.com`,
    departement: "VSN",
    status: statusList[index % statusList.length],
    isActive: Math.random() > 0.2,
    permis: "B",
    dateExpirationPermis: marketDate.toISOString().split('T')[0],
    titreCarteSejour: "123456789",
    cni: "987654321",
    dateOfBirth: "",
    civilite: "",
    address: MOCK_ADDRESSES[index % MOCK_ADDRESSES.length]
  }
})

export const DEFAULT_DRIVER_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° chauffeur", type: "text",align: "center" },
  { id: "firstName", label: "Prénom", type: "text" },
  { id: "lastName", label: "Nom", type: "text" },
  { id: "vehicle", label: "Véhicule", type: "text" },
  { id: "fuelCard", label: "Carte carburant", type: "text" },
  { id: "fuelVolume", label: "Volume carburant", type: "text", align: "center" },
  { id: "phone", label: "Téléphone", type: "text" },
  { id: "email", label: "Email", type: "text" },
  { id: "departement", label: "departement", type: "text" },
  { id: "status", label: "Status", type: "text" },
  { id: "permis", label: "Permis", type: "text" },
  { id: "dateExpirationPermis", label: "Date d'expiration permis", type: "date" },
  { id: "titreCarteSejour", label: "Titre de carte de sejour", type: "text" },
  { id: "cni", label: "CNI", type: "text" },
  { id: "", label: "Action" },
]

export const INITIAL_DRIVER_DATA: IDriver = {
  id: "",
  civilite: "",
  dateOfBirth: "",
  firstName: "",
  lastName: "",
  vehicle: "",
  fuelCard:[],
  fuelVolume: "",
  phone: "",
  email: "",
  departement: "",
  status: DriverRoadMapStatus.Disponible,
  isActive: true,
  address:INITIAL_ADDRESS,
  permis: "",
  dateExpirationPermis: "",
  titreCarteSejour: "",
  cni: "",
  fuelType:[]
}

export const _DRIVER_CIRCUIT = [
  {
    id: 1,
    fullName: 'Alice Dupont',
    circuitCode: 'EC-001',
  },
  {
    id: 2,
    fullName: 'Bob Martin',
    circuitCode: 'SC-002',
  },
  {
    id: 3,
    fullName: 'Claire Bernard',
    circuitCode: 'EC-001',
  },
  {
    id: 4,
    fullName: 'David Morel',
    circuitCode: 'SC-002',
  },
];
