import {
  type INotification,
  NotificationChannel,
  NotificationStatus,
  NotificationType,
  NotificationCategory,
  DeliveryType,
} from "../types/notification"

export const _notifications: INotification[] = [
  {
    id: "1",
    title: "Maintenance système planifiée",
    message: "Une maintenance système est planifiée pour le 15 avril 2025. Le système sera indisponible de 22h à 2h.",
    type: NotificationType.SYSTEM,
    category: NotificationCategory.MAINTENANCE,
    deliveryType: DeliveryType.PLANIFIE,
    recipients: ["Tous les utilisateurs"],
    sendImmediately: false,
    scheduledDate: "2025-04-15",
    scheduledTime: "21:00",
    channels: [NotificationChannel.EMAIL, NotificationChannel.PUSH],
    status: NotificationStatus.SENT,
    createdAt: "2025-04-10 14:30",
    updatedAt: "2025-04-10 14:30",
    isActive: true,
  },
  {
    id: "2",
    title: "Mise à jour de votre profil requise",
    message: "Veuillez mettre à jour vos informations de profil avant le 30 avril 2025.",
    type: NotificationType.PROFILE,
    category: NotificationCategory.RAPPEL,
    deliveryType: DeliveryType.IMMEDIAT,
    recipients: ["Utilisateurs du département RH"],
    sendImmediately: true,
    channels: [NotificationChannel.EMAIL],
    status: NotificationStatus.READ,
    createdAt: "2025-04-08 09:15",
    updatedAt: "2025-04-08 09:15",
    readAt: "2025-04-09 10:22",
    isActive: true,
  },
  {
    id: "3",
    title: "Nouvelle demande approuvée",
    message: "Votre demande #12345 a été approuvée par le responsable.",
    type: NotificationType.ACTIVITY,
    category: NotificationCategory.INFO,
    deliveryType: DeliveryType.IMMEDIAT,
    recipients: ["Jean Dupont"],
    sendImmediately: true,
    channels: [NotificationChannel.EMAIL, NotificationChannel.PUSH, NotificationChannel.SMS],
    status: NotificationStatus.READ,
    createdAt: "2025-04-05 16:45",
    updatedAt: "2025-04-05 16:45",
    readAt: "2025-04-05 17:02",
    isActive: true,
  },
  {
    id: "4",
    title: "Alerte de sécurité",
    message: "Une connexion inhabituelle a été détectée sur votre compte. Veuillez vérifier vos activités récentes.",
    type: NotificationType.ALERT,
    category: NotificationCategory.ALERTE,
    deliveryType: DeliveryType.IMMEDIAT,
    recipients: ["Marie Martin"],
    sendImmediately: true,
    channels: [NotificationChannel.EMAIL, NotificationChannel.PUSH, NotificationChannel.SMS],
    status: NotificationStatus.UNREAD,
    createdAt: "2025-04-03 22:10",
    updatedAt: "2025-04-03 22:10",
    isActive: true,
  },
  {
    id: "5",
    title: "Rappel: Réunion d'équipe",
    message: "Rappel: La réunion d'équipe hebdomadaire aura lieu demain à 10h.",
    type: NotificationType.INFO,
    category: NotificationCategory.RAPPEL,
    deliveryType: DeliveryType.PLANIFIE,
    recipients: ["Équipe Développement"],
    sendImmediately: false,
    scheduledDate: "2025-04-02",
    scheduledTime: "08:00",
    channels: [NotificationChannel.EMAIL, NotificationChannel.PUSH],
    status: NotificationStatus.ARCHIVED,
    createdAt: "2025-04-01 15:30",
    updatedAt: "2025-04-01 15:30",
    readAt: "2025-04-01 16:05",
    isActive: false,
  },
  {
    id: "6",
    title: "Nouvelle fonctionnalité disponible",
    message: "La gestion des notifications est maintenant disponible dans votre application.",
    type: NotificationType.INFO,
    category: NotificationCategory.MISE_A_JOUR,
    deliveryType: DeliveryType.IMMEDIAT,
    recipients: ["Tous les utilisateurs"],
    sendImmediately: true,
    channels: [NotificationChannel.PUSH],
    status: NotificationStatus.SENT,
    createdAt: "2025-03-28 11:20",
    updatedAt: "2025-03-28 11:20",
    isActive: true,
  },
  {
    id: "7",
    title: "Votre document a été partagé",
    message: 'Le document "Rapport Q1 2025" a été partagé avec vous par Pierre Durand.',
    type: NotificationType.ACTIVITY,
    category: NotificationCategory.INFO,
    deliveryType: DeliveryType.IMMEDIAT,
    recipients: ["Sophie Bernard"],
    sendImmediately: true,
    channels: [NotificationChannel.EMAIL],
    status: NotificationStatus.READ,
    createdAt: "2025-03-25 14:05",
    updatedAt: "2025-03-25 14:05",
    readAt: "2025-03-25 14:30",
    isActive: true,
  },
  {
    id: "8",
    title: "Rappel: Formation obligatoire",
    message:
      "Rappel: La formation sur la sécurité des données est obligatoire et doit être complétée avant le 15 mai 2025.",
    type: NotificationType.SYSTEM,
    category: NotificationCategory.RAPPEL,
    deliveryType: DeliveryType.PLANIFIE,
    recipients: ["Tous les employés"],
    sendImmediately: false,
    scheduledDate: "2025-04-15",
    scheduledTime: "09:00",
    attachment: "formation_securite.pdf",
    channels: [NotificationChannel.EMAIL],
    status: NotificationStatus.PENDING,
    createdAt: "2025-03-20 10:15",
    updatedAt: "2025-03-20 10:15",
    isActive: true,
  },
]

export {
  DEFAULT_NOTIFICATION_TABLE_HEAD,
  DEFAULT_NOTIFICATION_FILTERS,
  INITIAL_NOTIFICATION_DATA,
} from "../types/notification"
