import { INITIAL_ADDRESS } from ".";
import { Etat, Sens } from "../types/circuit";
import { TableColumn } from "../types/common";
import { BinaryQuestion, EtatTrajet, IAddPoint, ISuiviTrajet, ITrajet, TypeTrajet } from "../types/trajet";

export const _TRAJET_ETAT = [
  { value: "controle", label: "Contrôlé" },
  { value: "non_controle", label: "Non Contrôlé" },
  { value: "modifie", label: "Modifié" },
];
export const _BINARY_Qst = [
  { value: "oui", label: "Oui" },
  { value: "non", label: "Non" },
];

export const _OPTION_VEHICULE = [
  { value: Sens.Retour, label: "Bus" },
  { value: Sens.Retour, label: "Mini-Bus" },
  { value: Sens.Retour, label: "Berline" },
  { value: Sens.Retour, label: "Abarth" },
];


export const _TRAJET_TYPE = [
  { value: TypeTrajet.personnalise, label: "Trajet personnalisé" },
  { value: TypeTrajet.Normal, label: "Trajet normal" },
];
export const getTrajetType = (status: string): string => {
  const statusObj = _TRAJET_TYPE.find(s => s.value === status);
  return statusObj ? statusObj.label : "Inconnu";
};

  export const getTrajetEtat = (status: string): string => {
    const statusObj = _TRAJET_ETAT.find(s => s.value === status);
    return statusObj ? statusObj.label : "Inconnu";
  };

  
export const _trajets = [...Array(50)].map((_, index) => {
  const trajetDate = new Date(2024, Math.floor(index % 12), Math.floor((index % 28) + 1));
  const joursTrajet = ["Lun-Mar 18h", "Mar 17h", "Jeu-Ven 18h", "Mer-Ven 17h"][index % 4];
  const chauffeurNames = ["Ahmed Benomar", "Khalid Larbi", "Sara Amrani", "Hassan Moussa"];
  const vehicleTypes = ["Bus", "Mini-Bus", "Berline", "vehicule"];
  const clients = ["École Futur", "Groupe Alpha", "Entreprise Soleil", "Lycée Elites"];
  const randomValue = Math.random();

  return {
    id: (index + 1).toString(),
    dateDebut: trajetDate.toISOString().split('T')[0],
    intitule: joursTrajet,
    sensAR: index < 2  ? Sens.Aller : Sens.Retour,
    rotation:index < 2  ? BinaryQuestion.Oui : BinaryQuestion.Non,
    nombreUsagers: Math.floor(randomValue * 50) + 1,
    nombreEtablissements: Math.floor(randomValue * 5) + 1,
    etat: Object.values(EtatTrajet)[Math.floor(randomValue * Object.values(EtatTrajet).length)],
    chauffeur: index % 2 === 0 ? chauffeurNames[index % chauffeurNames.length] : "Non Affecté",
    vehicule: vehicleTypes[index % vehicleTypes.length],
    peages:index < 2  ? BinaryQuestion.Oui : BinaryQuestion.Non,
    societe: "Adanev",
    client: clients[index % clients.length],
    typeTrajet:randomValue < 0.4  ? TypeTrajet.Normal : TypeTrajet.personnalise,
    isActive: randomValue < 0.3,
  };
});

export const DEFAULT_TRAJET_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Trajet', type: 'text', align: 'left' },
  { id: 'dateDebut', label: 'Date de Début', type: 'date', align: 'center' },
  { id: 'days', label: 'Jours de Trajet', type: 'text', align: 'left' },
  { id: 'sensAR', label: 'Sens', type: 'status', align: 'left' },
  { id: 'rotation', label: 'Rotation', type: 'status', align: 'center' },
  { id: 'nombreUsagers', label: 'Nbr Usagers', type: 'text', align: 'center' },
  { id: 'nombreEtablissements', label: 'Nbr Établissements', type: 'text', align: 'center' },
  { id: 'etat', label: 'État', type: 'status', align: 'center' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'vehicule', label: 'Véhicule', type: 'text', align: 'left' },
  { id: 'peages', label: 'Péages inclus', type: 'status', align: 'center' },
  { id: 'societe', label: 'Société', type: 'text', align: 'left' },
  { id: 'client', label: 'Client', type: 'text', align: 'left' },
  { id: 'typeTrajet', label: 'Type', type: 'status', align: 'center' },
  { id: 'isActive', label: 'Active', type: 'boolean', align: 'center' },
  { id: '', label: 'Action' },
];

export const INITIAL_TRAJET_DATA: ITrajet = {
  id: '',
  dateDebut: '',
  intitule: '',
  sensAR: Sens.Aller,
  rotation: BinaryQuestion.Non,
  nombreUsagers: 0,
  nombreEtablissements: 0,
  etat: EtatTrajet.NonControle,
  chauffeur: '',
  vehicule: '',
  peages:BinaryQuestion.Non,
  societe: 'Adanev',
  client: '',
  typeTrajet: TypeTrajet.Normal,
  isActive: false,
};

export const _suiviTrajet: ISuiviTrajet[] = [...Array(4)].map((_, index) => {
  const condition = Math.random() < 0.4;

  return {
    id: (index + 1).toString(),
    tripId: `trip-${index + 1}`,
    nom: condition  ? "Passage Éveil" : "Route Sérénité", 
    adresse: condition  ? "Groupe Alpha, 31 Rue Savoir" : "École Clair, 3 Rue Savoir",
    horaire: "10:00",
    km: "10:50",
    tps: "12003",
    gps: "45",
    gps1: "45",
    gps2: "0",
  };
});

export const DEFAULT_SUIVIT_TRAJET_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° trajet', type: 'text' },
  { id: 'nom', label: 'Nom & adresse', type: 'text' },
  { id: 'horaire', label: 'Horaire', type: 'text',align:'center' },
  { id: 'km', label: 'Km', type: 'date',align:'center' },
  { id: 'tps', label: 'Tps (sec)', type: 'text',align:'center' },
  { id: 'gps', label: 'Gps', type: 'text',align:'center' },
  { id: 'gps1', label: '',align:'center'},
  { id: 'gps2', label: '' ,align:'center'},
];

export const INITIAL_ADD_POINT_DATA: IAddPoint = {
  endPoint: '',
  endPointAddress: INITIAL_ADDRESS,
  user: '',
  };
