const endpointPrefix = '/api/user';

export const userEndpoints = {
  user: {
    getAllUsers: endpointPrefix + "/all",
    client: {
      addClient: endpointPrefix + '/client/add',
      getAllClients: endpointPrefix + '/client/search',
      toggleActiveClient: (id: string) => `${endpointPrefix}/client/${id}/active`,
      getClientById: (id: string) => `/client/${id}`,
      updateClient: endpointPrefix + '/client/update',
      exportClients: endpointPrefix + '/client/export',
    },
    auth: {
      login: endpointPrefix + '/login',
      logout: endpointPrefix + '/logout',
      history: endpointPrefix + '/history',
    },
    clientType: {
      getAll: endpointPrefix + '/clientType/all',
    },
    Role: {
      getAllRoles: '/api/user/role/all',
      createRole: '/api/user/role/add',
      updateRole: (id: string | number) => `/api/user/role/update/${id}`,
      changeStatus: (id: string | number, status: 'ENABLED' | 'DISABLED') =>
        `/api/user/role/${id}/status?status=${status}`,
    },
    passenger: {
      getAllPassengers: endpointPrefix + '/passenger/search',
      getPassengerById: (id: string) => `/passenger/${id}`,
      updatePassenger: endpointPrefix + '/passenger/update',
      addPassenger: endpointPrefix + '/passenger/add',
      toggleArchive: (id: string) => endpointPrefix + `/passenger/${id}/toggle-archive`,
    },
    team: {
      getAllTeams: endpointPrefix + "/teams/search",
      createTeam: endpointPrefix + "/teams/create",
      updateTeam: endpointPrefix + "/teams/update",
      duplicateTeam: endpointPrefix + "/teams/duplicate",
      getTeamById: (id: string) => `${endpointPrefix}/teams/${id}`,
      toggleStatus: (id: string) => `${endpointPrefix}/teams/${id}/toggle-status`,
      removeMember: (teamId: number, memberId: number) => 
        `${endpointPrefix}/teams/${teamId}/members/${memberId}/remove`,
      exportTeams: endpointPrefix + "/teams/export",
    },
   
    
  },
};
