import { Checkbox, TableCell, TableRow } from "@mui/material";
import { alpha, styled } from "@mui/system";

  export const HeaderCell = styled(TableCell)(({ theme }) => ({
    textAlign: 'center',
    color: theme.palette.text.disabled,
    padding: '8px',
    border:"none"
  }));
  export const HeaderCellWidthColor = styled(HeaderCell)(({ theme }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
  }))
  export  const HeaderRow = styled(TableCell)(({ theme }) => ({
    textAlign: 'left',
    color: theme.palette.text.disabled,
    whiteSpace:'nowrap',
    fontWeight:500,
    }));
  export  const StyledTableRow = styled(TableRow)(({ theme }) => ({
    '& > *:first-of-type': {
      borderBottomLeftRadius: '10px',
      borderTopLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderTopRightRadius: '10px',
    },
  }));
  export  const StyledSubTableRow = styled(TableRow)(({ theme }) => ({
    '& > *:last-child': {
      borderBottomRightRadius: '10px',
    },
  }));
  export  const StyledFirstRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
   '& > *': {
    borderTop: '3px solid white',
  },
    '& > *:first-of-type': {
      borderTopLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderTopRightRadius: '10px',
    },
  }));

  export  const StyledEstablishmentRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: 'white',
    '& > *': {
      borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
    },
     '& > *:first-of-type': {
       borderTopLeftRadius: '10px',
       borderBottomLeftRadius: '10px',
     },
     '& > *:last-child': {
       borderTopRightRadius: '10px',
       borderBottomRightRadius: '10px',
     },
   }));
  export  const StyledSecondRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
    '& > *:first-of-type': {
      borderBottomLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderBottomRightRadius: '10px',
    },
  }));
  export const SensARCheckbox = styled(Checkbox)(({ theme }) => ({
    width: 20,
    height: 20,
    padding: 0,
    borderRadius: '50%',
    '& .MuiSvgIcon-root': {
      display: 'none',
    },
    '&.Mui-checked': {
      backgroundColor: theme.palette.primary.main,
    },
    '&:not(.Mui-checked)': {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
    },
  }));
