import { useState, useCallback, useMemo } from 'react';
import { IAgent } from '@/shared/types/agent';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_AGENT_DATA } from '@/shared/_mock/_agent';


const agentConfig: TabConfig<IAgent> = {
  type: 'agent',
  listTitle: 'Liste des agents',
  newItemTitle: 'Nouvel agent',
  initialData: INITIAL_AGENT_DATA,
  getItemCode: (agent) => agent.agentId,
};

export function useAgentTabs() {
  return useTabsManager<IAgent>(agentConfig);
}