import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_OLD_ROADMAPS_DATA } from '@/shared/_mock/_roadMap';
import { TableType } from '@/shared/types/common';
import { IOldRoadmap } from '@/shared/types/driver';


const oldRoadMapConfig: TabConfig<IOldRoadmap> = {
    type: TableType.DriverRoadmap,
    listTitle: 'Anciennes feuilles de route',
    newItemTitle: 'Anciennes feuilles de route',
    initialData: INITIAL_OLD_ROADMAPS_DATA,
    getItemCode: (roadmap) => roadmap.date,
};


export function useOldRoadMapTabs() {
  return useTabsManager<IOldRoadmap>(oldRoadMapConfig);
}