import { Box, Typography, Stack } from '@mui/material';
import {
  faBuilding,
  faCircleNotch,
  faUserTie,
  faHashtag,
  faIdCardAlt,
  faFileContract,
  faComment,
} from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { pxToRem } from '@/shared/theme/typography';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

const driverData = {
  lastName: 'Leblanc',
  firstName: 'Anna',
  agency: 'Agence Soleil',
  registration: 'GA 689479',
  fuelCardNumber: 'XX07905968',
  licenseCopyNumber: '689479',
  address: '75. Avenue de la somme',
  zipCity: '3700 Soleil',
};

type Props = {
  isRouteSheetInValidation?: boolean;
};

const DriverRoadMapDetails = ({ isRouteSheetInValidation = true }: Props) => {


  return (
    <Box sx={{ bgcolor: 'white',borderRadius:"12px", pb:'30px'}}>
      <Typography
        sx={{
          textAlign:"center",
          p:3,
          fontSize: pxToRem(30),
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {'Feuille de route du mois de Novembre'}
      </Typography>
      <Stack direction="row"  sx={{px:3,}} justifyContent="space-between">
        <Stack spacing={1}>
          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faUserTie} color="primary.main" width={16} />
            <Typography>Prénom : {driverData.firstName}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faUserTie} color="primary.main" width={16} />
            <Typography>Nom : {driverData.lastName}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faHashtag} color="primary.main" width={16} />
            <Typography>Num carte carburant : {driverData.fuelCardNumber}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faIdCardAlt} color="primary.main" width={16} />
            <Typography>Immatriculation: {driverData.registration}</Typography>
          </Stack>

          <Stack direction="row" alignItems="center" spacing={1}>
            <FontAwesome icon={faFileContract} color="primary.main" width={16} />
            <Typography>
              Num copie conforme de la licence: {driverData.licenseCopyNumber}
            </Typography>
          </Stack>
        </Stack>

        <Stack spacing={1.5}>
          <Stack direction="row" alignItems="flex-start" sx={{ textAlign: 'left' }} spacing={1}>
            <FontAwesome icon={faBuilding} color="primary.main" width={16} />
            <Box>
              <Typography>{driverData.agency}</Typography>
              <Typography>{driverData.address}</Typography>
              <Typography>{driverData.zipCity}</Typography>
            </Box>
          </Stack>

        </Stack>
      </Stack>

      <ConditionalComponent isValid={isRouteSheetInValidation}>
        <Box
          sx={{
            mt: 3,
            p: 1.5,
            bgcolor: 'rgba(255, 0, 0, 0.05)',
            borderRadius: '12px',
            display: 'flex',
            alignItems: 'center',
            gap: 1
          }}
        >
          <FontAwesomeIcon icon={faCircleNotch} spin color="red" />
          <Typography color="error.main">
            Feuilles de route en cours de validation
          </Typography>
        </Box>
      </ConditionalComponent>
    </Box>
  );
};

export default DriverRoadMapDetails;
