import React from 'react';
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
} from '@mui/material';
import { StyledTableContainer } from '@/shared/theme/css';
import { HeaderCell } from '@/shared/components/form/style';
import TablePaginationCustom from '@/shared/components/table/table-pagination-custom';
import { BaseStyledRow, TrajetStyledRow } from '@/shared/sections/contract/styles';
function createData(start: string, end: string) {
  return { start, end };
}

const rows = [
  createData('07:09:18', '08:16:50'),
  createData('08:22:40', '08:44:20'),
  createData('15:17:00', '15:24:08'),
  createData('15:26:48', '15:51:58'),
  createData('16:37:46', '17:51:00'),
  createData('16:37:46', '17:51:00'),
  createData('16:37:46', '17:51:00'),
  createData('16:37:46', '17:51:00'),
  createData('16:37:46', '17:51:00'),
  createData('16:37:46', '17:51:00'),
];

export default function GeolocTable() {
  const [page, setPage] = React.useState(0);
  const [rowsPerPage, setRowsPerPage] = React.useState(20);

  const handleChangePage = (event: unknown, newPage: number) => {
    setPage(newPage);
  };
  const handleChangeRowsPerPage = (event: React.ChangeEvent<HTMLInputElement>) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };
  return (
    <>
    <StyledTableContainer
      sx={{
        maxHeight: '410px',
      }}
    >
      <Table  stickyHeader aria-label="customized table" sx={{ flex: '1 1 auto', minHeight: 0 }}>
        <TableHead  sx={{ flexShrink: 0 }}>
          <BaseStyledRow  >
            <HeaderCell align="center" sx={{backgroundColor: "primary.lighter"}}>Début</HeaderCell>
            <HeaderCell align="center" sx={{backgroundColor: "primary.lighter"}}>Arrivée</HeaderCell>
          </BaseStyledRow>
        </TableHead>
        <TableBody sx={{ overflowY: 'auto', flexShrink: 1 }}>
          {(rowsPerPage > 0
            ? rows.slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
            : rows
          ).map((row, index) => (
            <TrajetStyledRow key={index}>
              <TableCell align="center" >{row.start}</TableCell>
              <TableCell align="center">{row.end}</TableCell>
            </TrajetStyledRow>
          ))}
        </TableBody>
      </Table>
    </StyledTableContainer>
      <TablePaginationCustom
        sx={{ flexShrink: 0 }}
        count={rows.length}
        page={page}
        onPageChange={handleChangePage}
        rowsPerPage={rowsPerPage}
        onRowsPerPageChange={handleChangeRowsPerPage}
      />
      </>
  );
}
