import * as yup from 'yup';

export const clientSchema = yup.object().shape({

  firstName: yup.string().required("Le prénom est requis"),

  lastName: yup.string().required("Le nom est requis"),

  email: yup
    .string()
    .email("Email invalide")
    .required("L'email est requis"),

  personalEmail: yup
    .string()
    .nullable()
    .email("Email personnel invalide"),

  phoneNumber: yup.string().required("Le téléphone mobile est requis"),

  landlinePhone: yup.string().required("Le téléphone fixe est requis"),

  siret: yup.string().required("Le numéro SIRET est requis"),

  tva: yup.string().required("Le numéro de TVA est requis"),

  agency_id: yup.number().required("L'ID de l'agence est requis"),
  
  
  mapAdresse: yup.object().shape({
      address: yup.string().required("L'adresse est requise"),
      lat: yup.number(),
      lng: yup.number(),
      city: yup.string(),
      postalCode: yup.string(),
      country: yup.string(),
      formattedAddress: yup.string().required("L'adresse est requise")
    }),
    agencyName: yup.string(),
  

});
