import { FormFieldType } from '@/shared/types/common';
import {
  faHashtag,
  faMobileScreenButton,
  faEnvelope,
  faGlobe,
  faFax,
  faStickyNote,
  faUserTie,
} from '@fortawesome/free-solid-svg-icons';
import { CIVILITY_OPTIONS, ESTABLISHMENT_SECTOR_OPTIONS, ESTABLISHMENT_TYPE_OPTIONS, EstablishmentRequest, EstablishmentResponsible } from '@/shared/types/establishment';


export const mainEtabformFields = (): FormFieldType<EstablishmentRequest>[] => [
  {
    name: 'establishmentCode',
    label: "Code de l'établissement",
    placeholder: 'Entrez un code',
    type: 'text',
    required: true,
    icon: faHashtag,
  },
  {
    name: 'establishmentName',
    label: "Nom de l'établissement",
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: '/assets/icons/form/ic_building.svg',
  },
  {
    name: 'uaiCode',
    label: 'Code UAI',
    type: 'text',
    required: true,
    placeholder: 'Entrez le code UAI',
    icon: faHashtag,
  },
];

export const detailsEtabformFields = (
  zoneOptions: { label: string, value: string }[],
  departmentOptions: { label: string, value: string }[],
): FormFieldType<EstablishmentRequest>[] => [
    {
      name: 'establishmentSector',
      label: 'Regime',
      type: 'select',
      required: true,
      options: ESTABLISHMENT_SECTOR_OPTIONS,
    },
    {
      name: 'colorCode',
      label: 'Code couleur',
      type: 'color',
      placeholder: 'Choisissez une couleur',
      required: true,
      icon: '/assets/icons/form/ic_palette.svg',
    },
    {
      name: 'mapAddress',
      label: 'Adresse',
      type: 'address',
      required: true,
      placeholder: 'Choisissez une adresse',
    },
    {
      name: "zoneId",
      label: "Zone scolaire",
      type: "select",
      required: true,
      options: zoneOptions,
    },
    {
      name: 'phoneNumber',
      label: 'Téléphone',
      type: 'text',
      placeholder: '00000 000 000',
      icon: faMobileScreenButton,
    },
    {
      name: 'departmentId',
      label: 'Département',
      type: 'select',
      required: true,
      options: departmentOptions,
    },
    {
      name: 'fax',
      label: 'Fax',
      type: 'text',
      placeholder: '00000 000 000',
      required: true,
      icon: faFax,
    },
    {
      name: 'email',
      label: 'Email',
      type: 'text',
      placeholder: 'Entrez un email',
      required: true,
      icon: faEnvelope,
    },
    {
      name: 'website',
      label: 'Site web',
      type: 'text',
      placeholder: 'Copiez un lien',
      icon: faGlobe,
    },
    {
      name: 'doId',
      label: 'ID du Do',
      placeholder: '0000 000 000 000',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'doCode',
      label: 'Code DO',
      placeholder: 'Saisissez un texte',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'establishmentType',
      label: 'Type',
      type: 'select',
      required: true,
      options: ESTABLISHMENT_TYPE_OPTIONS,
    },
  ];
export const observationformFields: FormFieldType<EstablishmentRequest>[] = [
  {
    name: 'observation',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
];
export const responsableEtabformFields: FormFieldType<EstablishmentResponsible>[] = [
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    required: true,
    options: CIVILITY_OPTIONS,
  },
  {
    name: 'lastName',
    label: 'Nom du responsable',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'firstName',
    label: 'Prénom du responsable',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'email',
    label: 'Email',
    type: 'text',
    placeholder: 'Entrez un email',
    required: true,
    icon: faEnvelope,
  },
  {
    name: 'phoneNumber',
    label: 'Téléphone mobile',
    type: 'text',
    placeholder: '00000 000 000',
    required: true,
    icon: faMobileScreenButton,
  },
];