import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { IFuelHistory } from '@/shared/types/flottes/fuelImport';

type Props = {
  selected: boolean;
  row: IFuelHistory;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

export default function FuelFeeTableRow({
  row,
  selected,
  onSelectRow,
  columns,
}: Props) {

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'registrationDate':
        return formatDate(value, dateFormat.isoDate);
      case 'kilometer':
        return `${value} km`;
      default:
        return value;
    }
  };

  return (
    <TrajetStyledRow style={{ cursor: 'pointer' }}>

      {columns.filter((c)=>c.id !=="isActive").map((column: any) => (
        <TableCell
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap' }}
        >
          {renderCellContent(column.id, row[column.id as keyof IFuelHistory])}
        </TableCell>
      ))}

    </TrajetStyledRow>
  );
}