import * as yup from 'yup'
import { AFFECTATION_OPTION_STATUT } from '@/shared/types/flottes/vehicle-affectation'

export const affectationSchema = yup.object().shape({
  marque: yup.string().required('La marque est requise'),
  modele: yup.string().required('Le modèle est requis'),
  numeroImmatriculation: yup.string().required('L\'immatriculation est requise'),
  chauffeur: yup.string().required('Le chauffeur est requis'),
  dateAffectation: yup.date().required('La date d\'affectation est requise'),
  dateRetour: yup.date().nullable(),
  statut: yup.string()
    .oneOf(AFFECTATION_OPTION_STATUT.map(option => option.value), 'Statut invalide')
    .required('Le statut est requis'),
  observation: yup.string()
}) 