'use client';

import {
  Button,
  Divider,
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  Typography,
} from '@mui/material';
import type { IMileage } from '@/shared/types/flottes/mileage';
import FontAwesome from '@/shared/components/fontawesome';
import { faCar, faPhone, faUserTie } from '@fortawesome/free-solid-svg-icons';
import { ScrollBox, StyledListItemIcon } from '@/shared/theme/css';
import CustomDrawer from '@/shared/components/drawer/custom-drawer';
import { Box } from '@mui/system';
import SvgColor from '@/shared/components/svg-color';

const DRAWER_WIDTH = 450;

type Props = {
  isOpen: any;
  onClose: () => void;
  rowData: IMileage;
};

export default function TreatedMileAgeDrawer({ isOpen, onClose, rowData }: Props) {
  const { firstname, lastname, telephone, car, circuit } = rowData;

  const handleClose = () => {
    onClose();
  };

  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen.value} onClose={onClose}>
      <Typography
        variant="h5"
        sx={{
          p: 2,
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {firstname} {lastname}
      </Typography>

      <ScrollBox sx={{ maxHeight: 'calc(100vh - 80px)' }}>
        <Box sx={{ p: 1 }}>
          <Divider />
          <List>
            <ListItem>
              <StyledListItemIcon>
                <FontAwesome icon={faUserTie} width={18} />
              </StyledListItemIcon>
              <ListItemText primary="Prénom" secondary={firstname} />
            </ListItem>
            <ListItem>
              <StyledListItemIcon>
                <FontAwesome icon={faUserTie} width={18} />
              </StyledListItemIcon>
              <ListItemText primary="Nom" secondary={lastname} />
            </ListItem>
            <ListItem>
              <StyledListItemIcon>
                <FontAwesome icon={faPhone} width={18} />
              </StyledListItemIcon>
              <ListItemText primary="Télephone" secondary={telephone} />
            </ListItem>
            <ListItem>
              <StyledListItemIcon sx={{ color: 'primary.main' }}>
                <FontAwesome icon={faCar} width={18}  />
              </StyledListItemIcon>
              <ListItemText primary="vehicle" secondary={car} />
            </ListItem>

            <ListItem>
              <ListItemIcon>
                <SvgColor
                  src="/assets/icons/menu/ic_exploitation.svg"
                  sx={{ color: 'primary.main', width: 18, height: 18 }}
                />{' '}
              </ListItemIcon>
              <ListItemText primary="Circuit Number" secondary={circuit} />
            </ListItem>
          </List>
          <Box sx={{ mt: 1, display: 'flex', justifyContent: 'flex-end' }}>
            <Button onClick={handleClose} type="submit" variant="outlined" color="primary">
              Fermer
            </Button>
          </Box>
        </Box>
      </ScrollBox>
    </CustomDrawer>
  );
}
