"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import Switch from "@mui/material/Switch"

import TableActionColumn from "@/shared/components/table/table-action-column"
import SvgColor from "@/shared/components/svg-color"

import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { formatDate, dateFormat } from "@/utils/format-time"
import { IVehicleType } from "@/shared/types/flottes/vehicule"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  handleEditVehicleType: (vehicleType: IVehicleType) => void
  handleDetailsVehicleType: (vehicleType: IVehicleType) => void
  selected: boolean
  row: IVehicleType
  onSelectRow: VoidFunction
  columns: TableColumn[]
}

const TOOLTIP_TITLES = {
  edit: "Modifier type de véhicule",
  duplicate: "Copier type de véhicule",
  active: "Type de véhicule actif",
  inactive: "Type de véhicule inactif",
}

export default function VehicleTypeTableRow({
  row,
  handleEditVehicleType,
  handleDetailsVehicleType,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "derniereModification":
        return formatDate(value, dateFormat.isoDate)
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover style={{ cursor: "pointer" }}>
      {columns.filter((c)=>c.id!=='isActive')
      .map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsVehicleType(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: "nowrap", py: column.id === "isActive" ? 0 : "inherit", ...(index === 0 && {position: "relative"}), }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.intitule) }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IVehicleType])}
        </TableCell>
      ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEditVehicleType(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}
