import { TableColumn } from "@/shared/types/common";

export const DOCUMENT_TABLE_HEAD: TableColumn[] = [
  {
    id: 'name',
    label: 'Nom',
    align: 'left',
    type: 'text',
  },  {
    id: 'type',
    label: 'Type',
    type: 'text',
  },
  // Remove or comment out the category line
  // { id: 'categoryId', label: 'Catégorie', type: 'text' },
  { id: 'uploadDate', label: 'Date de soumission', type: 'date' },
  { id: 'lastModified', label: 'Dernière modification', type: 'date', },
    {
      id: 'status',
      label: 'Status',
    },
    {
      id: 'priority',
      label: 'Priorité',
    },
  {
    id: 'actions',
    label: 'Actions',
  }
] as const;

export const DOCUMENT_FILTERS = {
  name: '',
  type: '',
  categoryId: '',
  isArchived: '',
};

export const ITEMS_PER_PAGE = [10, 25, 50, 100];

export const DOCUMENT_ACTIONS = {
  VIEW: 'Voir',
  EDIT: 'Modifier',
  DOWNLOAD: 'Télécharger',
  DELETE: 'Supprimer',
  PROCESS: 'Traiter',
  REJECT: 'Rejeter',
  ARCHIVE: 'Archiver',
} as const;

export const ROWS_PER_PAGE = [5, 10, 25];

// Update tooltip titles
const TOOLTIP_TITLES = {
  edit: "Modifier document",
  duplicate: "Copier document",
  active: "Document non traité",
  inactive: "Document archivé",
};