import { Chip } from '@mui/material';
import { styled } from '@mui/system';

export const SalarieStatusChip = styled(Chip)(({ status, theme, width }: { status: string; theme: any, width?: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: width || '100%',
    ...((status === 'Salarié' || status === 'contrat' || status === 'RH' || status === 'traité') && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...((status === 'Sorti' || status === 'attestation' || status === 'PAIE' || status === 'non traité') && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...((status === 'Archivé' || status === 'fiche de paie') && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'autre' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
}));