import { ModeType } from '@/shared/types/common';
import { DriverAbsenceStatus } from '@/shared/types/driver-absence';
export interface IRHAbsence {
  id: string;
  numeroEnregistrement: string;
  nomChauffeur: string;
  type: 'chauffeur' | 'sédentaire';
  typeAbsence: string;
  dateDebut: string;
  dateFin: string;
  statut: DriverAbsenceStatus;
  justificatif: string;
  affecteTrajet: string;
  modeReception: string;
  nbrHeures: number;
  validerPar: string;
  autorisePar: string;
  departement: string;
}

export interface RHAbsenceTableRowProps<T> {
  row: T;
  dense: boolean;
  selected: boolean;
  onSelectRow: () => void;
  handleEdit: (item: T) => void;
  handleDetails: (item: T) => void;
  columns: any[];
  onStatusChange?: (row: T, newStatus: string, field: keyof T) => void;
  isTraiteTable?: boolean;
}

export interface RHAbsenceFormProps {
  absence: IRHAbsence;
  mode: ModeType;
  onSave: (updatedAbsence: IRHAbsence) => void;
  onEdit: (updatedAbsence: IRHAbsence) => void;
  onClose: () => void;
  isTraiteAbsence?: boolean;
} 