import { AddressData } from "./common";
import { IRole } from "./role";

export interface IAgent {
    id: string;
    lastName: string;          // nom
    firstName: string;         // prenom
    birthDate: string;        // dateNaissance
    birthPlace: string;       // lieuNaissance
    address: AddressData;          // adresse
    phone: string;            // telephone
    email: string;
    personalEmail?: string;
    password: string;
    socialSecurityNumber: string;  // numeroSecuriteSociale
    agentId: string;          // identifiantAgent
    agency: string;           // agence
    department: string;       // departement
    contractType: string;     // typeContrat
    status: string;           // statut
    roles:  IRole[];
    permissions: string[];
    isActive: boolean;
    connectionHistory ?: ConnectionSession[];
    team?: string;
  }
  export interface ConnectionSession {
    id: string;
    startTime: string;
    endTime: string | null;
    duration: number | null;  // durée en minutes
    date: string;
}
  
