export enum FormulaireTab {
  All = 'all',
}

export enum FieldType {
  TEXT = 'TEXT',
  SELECT = 'SELECT',
  CHECKBOX = 'CHECKBOX',
  RADIO = 'RADIO',
  DATE = 'DATE',
  FILE = 'FILE',
  RATING = 'RATING',
  CONSENT = 'CONSENT',
  TEXTAREA = 'TEXTAREA',
  NUMBER = 'NUMBER',
  EMAIL = 'EMAIL',
  PHONE = 'PHONE',
  SECTION = 'SECTION',
}

export enum FieldCategory {
  Personal = 'personal',
  Administrative = 'administrative',
  HR = 'hr',
  JobSpecific = 'jobSpecific',
  Other = 'other',
}

export interface FormulaireChamp {
  id: string;
  label: string;
  type: string;
  required: boolean;
  options?: Array<{ value: string; label: string }>;
  category?: FieldCategory;
  placeholder?: string;
  defaultValue?: any;
  validations?: {
    pattern?: string;
    min?: number;
    max?: number;
    minLength?: number;
    maxLength?: number;
  };
  conditionalLogic?: {
    dependsOn?: string;
    showWhen?: {
      value: any;
      operator: 'equals' | 'notEquals' | 'contains' | 'greaterThan' | 'lessThan';
    };
  };
  columns?: number;
  childFields?: string[];
  sectionTitle?: string;
  sectionDescription?: string;
  sectionCollapsible?: boolean;
  sectionCollapsed?: boolean;
  sectionStyle?: 'default' | 'card' | 'outlined' | 'filled';
}

export interface IFormulaire {
  id: string;
  title: string;
  description: string;
  createdDate: string;
  lastModifiedDate: string;
  creator: string;
  fields: FormulaireChamp[];
  category?: string;
  department?: string;
  notifications?: boolean;
  layout?: 'vertical' | 'horizontal';
  theme?: 'light' | 'dark';
  accessibilityOptions?: {
    highContrast?: boolean;
    largeText?: boolean;
    screenReaderOptimized?: boolean;
  };
  exportOptions?: {
    allowPdfExport?: boolean;
    allowPrint?: boolean;
    allowDataExport?: boolean;
  };
}

export const INITIAL_FORMULAIRE_DATA: IFormulaire = {
  id: '',
  title: '',
  description: '',
  createdDate: new Date().toISOString(),
  lastModifiedDate: new Date().toISOString(),
  creator: '',
  fields: [],
  layout: 'vertical',
  accessibilityOptions: {
    highContrast: false,
    largeText: false,
    screenReaderOptimized: false,
  },
  exportOptions: {
    allowPdfExport: true,
    allowPrint: true,
    allowDataExport: true,
  },
};
