import IconButton from '@mui/material/IconButton';
import { faMapMarkedAlt, faTable } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import { useRouter } from 'next/navigation';
import { paths } from '@/routes/paths';

// ----------------------------------------------------------------------

export default function PositionPopover() {
  const router = useRouter();

  const handleClick = () => {
    router.push(paths.dashboard.geolocalisation.root);
  };
  return (
    <CustomTooltip title="Géolocalisation" arrow>
      <IconButton sx={WhiteIconButtonStyle} onClick={handleClick}>
        <FontAwesome icon={faMapMarkedAlt} />
      </IconButton>
    </CustomTooltip>
  );
}
