import { TableColumn } from "../types/common";
import { IEquipe, TeamStatus } from "../types/equipe";
import { _agents } from "./_agent";

export const _TEAM_STATUS = [
  { value: "active", label: "Actif" },
  { value: "inactive", label: "Inactif" },
];

export const _teams = [...Array(24)].map((_, index) => {
  const creationDate = new Date(2020 + Math.floor(index / 12), index % 12, 15);
  const teamCode = `TM${(12345 + index).toString().padStart(5, '0')}`;

  const numAgents = Math.floor(Math.random() * 4) + 2;
  const agentIds = _agents
    .slice(0, 20)
    .sort(() => 0.5 - Math.random())
    .slice(0, numAgents)
    .map(agent => agent.id);

  return {
    id: teamCode,
    name: [
      "Alpha Team",
      "Beta Squad",
      "Delta Force",
      "Echo Unit",
      "Gamma Group"
    ][index % 5],
    teamLeader: [
      "John Smith",
      "Emma Wilson",
      "Michael Brown",
      "Sarah Davis",
      "James Miller"
    ][index % 5],
    agency: [
      "Paris Agency",
      "Lyon Agency",
      "Marseille Agency",
      "Toulouse Agency",
      "Bordeaux Agency"
    ][index % 5],
    department: [
      "Operations",
      "Logistics",
      "Transport",
      "Planning",
      "Support"
    ][index % 5],
    sector: [
      "North",
      "South",
      "East",
      "West",
      "Central"
    ][index % 5],
    creationDate: creationDate.toISOString().split('T')[0],
    status: _TEAM_STATUS[index % 2].value,
    isActive: Math.random() < 0.7,
    agents: agentIds,
  };
});

export const getTeamStatus = (status: string): string => {
  const statusObj = _TEAM_STATUS.find(s => s.value === status);
  return statusObj ? statusObj.label : "Unknown";
};

export const DEFAULT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'Code Équipe', type: 'text' },
  { id: 'name', label: 'Nom d\'équipe', type: 'text' },
  { id: 'teamLeader', label: 'Chef d\'équipe', type: 'text' },
  { id: 'department', label: 'Département', type: 'text' },
  { id: 'creationDate', label: 'Date de création', type: 'date' },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'isActive', label: 'Actif', type: 'boolean' },
  { id: '', label: 'Action' },
];

export const INITIAL_TEAM_DATA: IEquipe = {
  id: '',
  name: '',
  teamLeaderId:0,
  department: { id: 0 },
  creationDate: '',
  status: TeamStatus.ACTIVE,
  teamCode: '',
  teamLeaderFullName:'',
  collaborators: [],
  
};