import { Departements, IAttendanceNotCher, IAttendanceSheet, IAttendanceSheetCher, Months } from '../types/etablissement';

const monthsArray = Object.values(Months);
const departementsArray = Object.values(Departements);
const getRandomInt = (max: number) => Math.floor(Math.random() * max);

export const _attendanceSheet = [...Array(50)].map((_, index) => {
  const year = 2024 + getRandomInt(2);
  return {
    id: (index + 1).toString(),
    number: (index + 1).toString().padStart(7, '0'),
    circuitName: `La Traversée Parisienne ${index + 1}`,
    departmentName: departementsArray[getRandomInt(departementsArray.length)],
    year: year.toString(),
    month: monthsArray[getRandomInt(monthsArray.length)],
    isActive: Math.random() > 0.2,
  };
});

export const DEFAULT_ATTENDANCE_TABLE_HEAD = [
  { id: 'number', label: 'Numero', type: 'text' },
  { id: 'circuitName', label: 'Nom du circuit', type: 'text' },
  { id: 'departmentName', label: 'Departement', type: 'text' },
  { id: 'year', label: 'Année', type: 'text' },
  { id: 'month', label: 'Mois', type: 'text' },
  { id: '', label: 'Action' },
];

export const INITIAL_ATTENDANCE_DATA: IAttendanceSheet = {
  id: "",
  number: "",
  circuitName: "",
  departmentName: Departements.Cher,
  year: "",
  month: "",
  isActive: true,
}

export const mockCherDetails: IAttendanceSheetCher = {
  id: "1",
  nomCircuit: "Circuit Bourges-Vierzon",
  departement: Departements.Cher,
  mois: "3",
  annee: "2025",
  nom: "Dupont",
  prenom: "Jean",
  etablissement: "Collège Victor Hugo",
  adresse: "12 Rue de l'École, 18000 Bourges",
  telephone: "02 48 45 67 89",
  joursClasse: "20",
  transportAR: "36",
  nomResponsable: "Dupont Jean",
}

export const mockNotCherDetails: IAttendanceNotCher = {
  departement: Departements.Côte_dOr,
  mois: "3",
  annee: "2025",
  transporteur: "Transport Express",
  circuit: "Circuit Orléans-Tours",
  etablissement: "Lycée Molière",
  eleveA: "Martin Sophie",
  eleveB: "Dubois Pierre",
  eleveC: "Leroy Emma",
  eleveD: "Morel",
  eleveE: "Laurent",
  observation: "RAS",
}