import type { TableColumn } from "@/shared/types/common";
import { _petrolier } from "..";
import { IFuelHistory } from '../../types/flottes/fuelImport';

export const _fuelHistories: IFuelHistory[] = [...Array(30)].map((_, i) => {
  const id = `${(i + 1).toString().padStart(6, "0")}`;
  const registrationDate = new Date(2025, Math.floor(i / 6), 3 + (i % 28)).toISOString().split("T")[0];

  return {
    id,
    providerType: _petrolier[i % _petrolier.length],
    registrationDate,
    kilometer: (Math.floor(Math.random() * 50000) + 1000).toString(),
    isActive: Math.random() < 0.8,
  };
});

export const DEFAULT_FUELHISTORY_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "providerType", label: "Pétrolier", type: "text" },
  { id: "registrationDate", label: "Date immatriculation", type: "date" },
  { id: "kilometer", label: "Kilomètre", type: "text" },
];
export const DEFAULT_FUEL_CARD_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "providerType", label: "Pétrolier", type: "text" },
  { id: "registrationDate", label: "Date immatriculation", type: "date" },
  { id: "kilometer", label: "Kilomètre", type: "text" },
  { id: 'isActive', label: 'Active', type: 'boolean' },
  { id: "", label: "Action" },
];

export const INITIAL_FUELHISTORY_DATA: IFuelHistory = {
  id: "",
  providerType: "",
  registrationDate: "",
  kilometer: "",
  supplierFile:"",
  isActive: true,
};
