const endpointPrefix = "/api/admin"

export const endpoints = {
  Admin: {
    Infrastructure: {
      Sector: {
        getSectorNamesAndIds: endpointPrefix + "/infrastructure/sectors/all-names-ids",
        getSectorsPage: endpointPrefix + "/infrastructure/sectors/page",
        toggleSectorActivation: (sectorId: string, active: boolean) => endpointPrefix + `/infrastructure/sectors/toggle-activation/${sectorId}?active=${active}`,
        getSectorById: (sectorId: string) => endpointPrefix + `/infrastructure/sectors/${sectorId}`,
        createSector: endpointPrefix + "/infrastructure/sectors",
        updateSector: (sectorId: string) => endpointPrefix + `/infrastructure/sectors/update/${sectorId}`,
        startExportInfrastructureDataInExcel: endpointPrefix + `/infrastructure/sectors/start-infrastructure-export-excel`,
        exportInfrastructureDataInPdf: endpointPrefix + `/infrastructure/sectors/export/pdf`,
      },
      Agency: {
        getAgencyNamesAndIds: endpointPrefix + "/infrastructure/agencies/all-names-ids",
        getAgencyPage: endpointPrefix + "/infrastructure/agencies/page",
        toggleAgencyActivation: (agencyId: string, active: boolean) => endpointPrefix + `/infrastructure/agencies/toggle-activation/${agencyId}?active=${active}`,
        getAgencyById: (agencyId: string) => endpointPrefix + `/infrastructure/agencies/${agencyId}`,
        createAgency: endpointPrefix + "/infrastructure/agencies",
        updateAgency: (agencyId: string) => endpointPrefix + `/infrastructure/agencies/update/${agencyId}`,
      },
      Department: {
        getDepartmentNamesAndIds: endpointPrefix + "/infrastructure/departments/all-names-ids",
        getDepartmentNamesAndIdsByAgencyId: (agencyId: number) => endpointPrefix + `/infrastructure/departments/all-names-ids-by-agencyId/${agencyId}`,
        getDepartmentPage: endpointPrefix + "/infrastructure/departments/page",
        toggleDepartmentActivation: (departmentId: string, active: boolean) => endpointPrefix + `/infrastructure/departments/toggle-activation/${departmentId}?active=${active}`,
        getDepartmentById: (departmentId: string) => endpointPrefix + `/infrastructure/departments/${departmentId}`,
        createDepartment: endpointPrefix + "/infrastructure/departments",
        updateDepartment: (departmentId: string) => endpointPrefix + `/infrastructure/departments/update/${departmentId}`,
      },
      Lot: {
        getLotNumbersAndIds: endpointPrefix + "/infrastructure/lots/all-numbers-ids",
        getLotNumbersAndIdsByDepartmentId: (departmentId: number) => endpointPrefix + `/infrastructure/lots/all-numbers-ids-by-departmentId/${departmentId}`,
        getLotPage: endpointPrefix + "/infrastructure/lots/page",
        toggleLotActivation: (lotId: string, active: boolean) => endpointPrefix + `/infrastructure/lots/toggle-activation/${lotId}?active=${active}`,
        getLotById: (lotId: string) => endpointPrefix + `/infrastructure/lots/${lotId}`,
        createLot: endpointPrefix + "/infrastructure/lots",
        updateLot: (lotId: string) => endpointPrefix + `/infrastructure/lots/update/${lotId}`,
      }
    },
    Contract: {
      getContractsPage: endpointPrefix + "/contracts/page",
      getContractById: (id: string) => endpointPrefix + `/contracts/${id}`,
      createContract: endpointPrefix + "/contracts",
      toogleActivation: (id: string, active: boolean) => endpointPrefix + `/contracts/toggle-activation/${id}?active=${active}`,
      updateContract: (id: string) => endpointPrefix + `/contracts/update/${id}`,
      startExportFiltredContracts: endpointPrefix + "/contracts/start-filtered-export",
      updateContractStatus: (id: string) => endpointPrefix + `/contracts/update-status/${id}`,
    },
    Establishment: {
      getEstablishmentsPage: endpointPrefix + "/establishments/page",
      toggleActivation: (id: string, active: boolean) => endpointPrefix + `/establishments/toggle-activation/${id}?active=${active}`,
      getEstablishmentById: (id: string) => endpointPrefix + `/establishments/${id}`,
    }
  }
};
