
const CIRCUIT_URL = '/api/circuit';

export const endpoints_Trajet = {
    
Trajet: {
    getTrajetsPage: `${CIRCUIT_URL}/trips`,
    getTrajetById: (id: string) => `${CIRCUIT_URL}/trips/${id}`,
    createTrajet: `${CIRCUIT_URL}/trips`,
    updateTrajet: (id: string) => `${CIRCUIT_URL}/trips/${id}`,
    toggleTrajetActivation: (id: string, isActive: boolean) => 
      `${CIRCUIT_URL}/trips/${id}/toggle-activation?isActive=${isActive}`,
    updateTrajetStatus: (id: string, field: string) => 
      `${CIRCUIT_URL}/${id}/update-status/${field}`,
    getSuiviTrajets: (id: string) => `${CIRCUIT_URL}/trips/${id}/suivi`,
    updateSuiviTrajets: (id: string) => `${CIRCUIT_URL}/trips/${id}/suivi`,
    addTripPoint: (id: string) => `${CIRCUIT_URL}/api/trip-points`,
    deleteTripPoint: (id: string) => `${CIRCUIT_URL}/api/trip-points/${id}`,
    reorderTripPoints: (id: string) => `${CIRCUIT_URL}/api/trip-points/reorder?tripId=${id}`,
    exportTrajetDataInCsv: `${CIRCUIT_URL}/trips/export/csv`,
    exportTrajetDataInPdf: `${CIRCUIT_URL}/trips/export/pdf`,
    filterTrajets: `${CIRCUIT_URL}/filter`,
    TripPoint: {
      getPoints: (tripId: string) => `${CIRCUIT_URL}/trip-points/trip/${tripId}`,
      addPoint: `${CIRCUIT_URL}/trip-points`,
      updatePoint: (pointId: string) => `${CIRCUIT_URL}/trip-points/${pointId}`,
      deletePoint: (pointId: string) => `${CIRCUIT_URL}/trip-points/${pointId}`,
      reorderPoints: (tripId: string) => `${CIRCUIT_URL}/trip-points/reorder?tripId=${tripId}`,
    }
  },
}