import { create } from 'zustand';
import axiosInstance from '@/utils/axios';
import { Agencies, AgencyNames } from '@/shared/types/infrastructure';
import { endpoints } from '../endpoints/Infras';


type AgencyStore = {
  agencies: Agencies[];
  agenciesName:AgencyNames[];
  loading: boolean;
  error: string | null;
  fetchAgenciesName: () => Promise<void>;
};

export const useAgencyStore = create<AgencyStore>((set: any) => ({
  agencies: [],
  agenciesName:[],
  loading: false,
  error: null,
  fetchAgenciesName: async () => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.get<AgencyNames[]>(endpoints.Admin.Infrastructure.Agency.getAgencyNamesAndIds); 
      set({ agenciesName: response.data, loading: false });
    } catch (error: any) {
      set({ error: error.message || 'Failed to fetch agencies', loading: false });
    }finally{
        set({loading:false})
    }
  },
}));
