import React from 'react';
import { Box, IconButton, Typography } from '@mui/material';
import { faAngleLeft, faAngleRight, faAnglesLeft, faAnglesRight } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '../fontawesome';

interface ControlButtonsProps {
  onMoveAllToAvailable: () => void;
  onMoveSelectedToAvailable: () => void;
  onMoveAllToSelected: () => void;
  onMoveSelectedToSelected: () => void;
}

export const ControlButtons: React.FC<ControlButtonsProps> = ({
  onMoveAllToAvailable,
  onMoveSelectedToAvailable,
  onMoveAllToSelected,
  onMoveSelectedToSelected,
}) => (
  <Box
    sx={{
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      alignItems: 'center',
      gap: 1,
    }}
  >
    <IconButton
      sx={{ bgcolor: 'background.paper' }}
      onClick={onMoveAllToAvailable}
    >
      <FontAwesome width={13} icon={faAnglesLeft} />
    </IconButton>
    <IconButton
      sx={{ bgcolor: 'background.paper' }}
      onClick={onMoveSelectedToAvailable}
    >
      <FontAwesome width={13} icon={faAngleLeft} />
    </IconButton>
    <Typography
      sx={{
        fontSize: 10,
        color: 'text.secondary',
        textAlign: 'center',
      }}
    >
      Glissez-déposez ici
    </Typography>
    <IconButton
      sx={{ bgcolor: 'background.paper' }}
      onClick={onMoveAllToSelected}
    >
      <FontAwesome width={13} icon={faAnglesRight} />
    </IconButton>
    <IconButton
      sx={{ bgcolor: 'background.paper' }}
      onClick={onMoveSelectedToSelected}
    >
      <FontAwesome width={13} icon={faAngleRight} />
    </IconButton>
  </Box>
);

