"use client"

import { Box, Button, CircularProgress } from "@mui/material"
import { mainColor, outlinedColor, outlinedGreyColor } from "../table/styles"
import type { ReactNode } from "react"
import ConditionalComponent from "../table/ConditionalComponent"
import { StyledCircularProgress } from "./style"

interface ActionButtonsProps {
  onCancel: () => void
  onSave: () => void
  onValidate?: () => void
  onNext?: () => void;
  onBack?: () => void;
  mode?: string
  secoundButtonText?: string
  thirdButtonText?: string
  additionalButton?: ReactNode
  loading?: boolean
}

export default function ActionButtons({
  onCancel,
  onSave,
  onNext,
  onBack,
  onValidate,
  mode,
  secoundButtonText,
  thirdButtonText,
  additionalButton,
  loading
}: ActionButtonsProps) {
  return (
    <Box display="flex" justifyContent="flex-end" gap={2}>
      {/* Bouton Annuler */}
      <Button
        variant="outlined"
        onClick={onCancel}
        sx={{
          textTransform: "none",
          ...(onNext ? outlinedGreyColor : outlinedColor),
        }}
      >
        Annuler
      </Button>

      {/* Bouton Précédent (si disponible) */}
      {onBack && (
        <Button
          variant="outlined"
          onClick={onBack}
          sx={{
            textTransform: "none",
            ...outlinedColor,
          }}
        >
          Précédent
        </Button>
      )}

      {/* Bouton Suivant ou Enregistrer */}
      <Button
        variant={onNext ? "outlined" : "contained"}
        onClick={onNext || onSave}
        sx={{
          boxShadow: "none",
          textTransform: "none",
          ...(onNext ? outlinedColor : mainColor),
        }}
        disabled={loading}
      >
        <ConditionalComponent isValid={!!loading}>
          <StyledCircularProgress size={15} color="inherit"/>
        </ConditionalComponent>
        {secoundButtonText || 
          (onNext ? "Suivant" : 
            mode === "edit" ? "Enregistrer" : "Ajouter")}

      </Button>
      {onValidate ? (
        <Button
          variant="outlined"
          onClick={onValidate}
          sx={{
            boxShadow: "none",
            textTransform: "none",
            ...mainColor,
          }}
        >
          {thirdButtonText || "Enregistrer et Valider"}
        </Button>
      ) : (
        <></>
      )}
      {additionalButton ? <Box>{additionalButton}</Box>: <></>}
    </Box>
  )
}